<?php
// Obtém os dados
$dados = [
    'status' => 'success',
    'data' => [
        'count' => [
            'movies' => DB::table('movies')->count(),
            'series' => DB::table('series')->count(),
            'animes' => DB::table('animes')->count(),
            'users' => DB::table('episodes')->count(),
            'animesep' => DB::table('anime_episodes')->count()
        ]
    ]
];

// Converte os dados em formato JSON
$jsonData = json_encode($dados);
?>

<!DOCTYPE html>
<html>
<head>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    <title>Quantidade de Filmes</title>
    <script>
        // Obtém os dados JSON do PHP
        var jsonData = <?php echo $jsonData; ?>;

        // Função para atualizar os elementos na página com os dados
        function atualizarDados() {
            var moviesCount = document.getElementById('moviesCount');
            var seriesCount = document.getElementById('seriesCount');
            var animesCount = document.getElementById('animesCount');
            var usersCount = document.getElementById('usersCount');
            var animesEpCount = document.getElementById('animesEpCount');

            moviesCount.innerText = jsonData.data.count.movies;
            seriesCount.innerText = jsonData.data.count.series;
            animesCount.innerText = jsonData.data.count.animes;
            usersCount.innerText = jsonData.data.count.users;
            animesEpCount.innerText = jsonData.data.count.animesep;
        }

        // Atualiza os dados assim que a página é carregada
        window.onload = atualizarDados;
    </script>
</head>
<body>
    <div class="conteinerm">
    <h1>Você terá acesso a:</h1>
    <p><i class="fas fa-film"></i> <span id="moviesCount"></span> Filmes</p>
    <p><i class="fas fa-tv"></i> <span id="seriesCount"></span> Séries</p>
    <p><i class="fas fa-tv"></i> <span id="animesCount"></span> Animes</p>
    <p><i class="fas fa-video"></i> <span id="usersCount"></span> Episódios de Séries</p>
    <p><i class="fas fa-video"></i> <span id="animesEpCount"></span> Episódios de Animes</p>
</div>

</body>
</html>
