<!DOCTYPE html>
<html>
<meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
<head>
    <title>Pesquisa de Filmes e Séries</title>
    <link rel="stylesheet" href="/public/css/web.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>

</head>
<body>
@include('layouts._partials.header')

    <section class="container-busca">

    <form action="{{ route('search') }}" method="GET">
        <div class="Input">
            <input type="text" name="search" placeholder="O que você está procurando ?" id="searchInput">
        </div>
    </form>

    <div id="realTimeResults"></div>


<div class="suggesteds">
    <div class="suggested-section">
        <h3>Filmes Sugeridos</h3>
        <div class="suggested-items">
            @foreach ($suggestedMovies as $suggestedMovie)
                <div class="suggested-item">
                    <a href="{{ route('filme.detail', ['id' => $suggestedMovie->id]) }}">
                        <img src="{{ $suggestedMovie->poster_path }}" alt="{{ $suggestedMovie->name }}">
                    </a>
                </div>
            @endforeach
        </div>
    </div>

    <!-- Sugestões de Séries -->
    <div class="suggested-section">
        <h3>Séries Sugeridas</h3>
        <div class="suggested-items">
            @foreach ($suggestedSeries as $suggestedSerie)
                <div class="suggested-item">
                    <a href="{{ route('serie.detail', ['id' => $suggestedSerie->id]) }}">
                        <img src="{{ $suggestedSerie->poster_path }}" alt="{{ $suggestedSerie->name }}">
                    </a>
                </div>
            @endforeach
        </div>
    </div>
</div>
    
</section>


</body>

<script>
    $(document).ready(function() {
        $('#searchInput').keydown(function(event) {
            if (event.keyCode === 13) {
                event.preventDefault();
                return false;
            }
        });

        $('#searchInput').on('input', function() {
            var searchText = $(this).val();

            if (searchText.length >= 3) {
                $.ajax({
                    url: "{{ route('realtime.search') }}", // Use a rota de busca em tempo real
                    method: 'GET',
                    data: { search: searchText },
                    success: function(response) {
                        // Atualiza o conteúdo dos resultados
                        $('#realTimeResults').html(response);

                        // Adiciona a classe para mostrar os resultados com animação
                        $('.results-section').addClass('show-results');

                        $('.suggesteds').hide();
                    }
                });
            } else {
                // Remove a classe para esconder os resultados com animação
                $('.results-section').removeClass('show-results');

                $('#realTimeResults').empty();
                $('.suggesteds').show();
            }
        });
    });
</script>





</body>
</html>
