<!DOCTYPE html>
<html>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<head>
    <title>Séries</title>
    <link rel="stylesheet" href="/public/css/web.css">
</head>
<body>

    @include('layouts._partials.header')

    <div class="container-series">
        <div class="series-list">
            @foreach ($series as $serie)
                <div class="serie">
                    <a href="{{ route('serie.detail', $serie->id) }}">
                        <figure>
                            <img src="{{ $serie->poster_path }}" alt="{{ $serie->name }}">
                        </figure>
                    </a>
                </div>
            @endforeach
        </div>

        <div class="pagination">
                
                <span class="pagination-links">
                    @if ($series->currentPage() > 1)
                        <a href="{{ $series->previousPageUrl() }}">Anterior</a>
                    @endif

                    @for ($i = max(1, $series->currentPage() - 1); $i <= min($series->lastPage(), $series->currentPage() + 1); $i++)
                        <a href="{{ $series->url($i) }}" class="{{ $i === $series->currentPage() ? 'active' : '' }}">{{ $i }}</a>
                    @endfor

                    @if ($series->hasMorePages())
                        <a href="{{ $series->nextPageUrl() }}">Próxima</a>
                    @endif
                </span>
            </div>
    </div>
</body>
</html>
