<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Inicio</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.css">
    <link rel="stylesheet" href="https://unpkg.com/swiper/swiper-bundle.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@splidejs/splide@3.0.0/dist/css/splide.min.css">
</head>
<body>

@php

use Carbon\Carbon

@endphp

@include('layouts._partials.header')

<section class="featured">
    <div class="splide" id="featured-slider">
        <div class="splide__track">
            <ul class="splide__list">
                @foreach ($featured as $item)
                    <li class="splide__slide">
                        @if ($item->type === 'Movie')
                            <a href="{{ route('filme.detail', ['id' => $item->featured_id]) }}" class="filme-link">
                        @elseif ($item->type === 'Serie')
                            <a href="{{ route('serie.detail', ['id' => $item->featured_id]) }}" class="filme-link">
                        @endif
                        <div class="destaque destaque-gradient">
                            <img src="{{ $item->backdrop_path_tv }}" alt="{{ $item->title }}">
                        </div>
                        <figure class="miniposter">
                            <img src="{{ $item->miniposter }}" alt="{{ $item->title }}">
                            <div class="info">
                                <p class="imdb">{{ $item->vote_average }}<i class="fas fa-star"></i></p>
                                <p class="genero">{{ $item->genre }}</p>
                                <li>{{ Carbon::createFromFormat('Y-m-d', $item->release_date)->format('Y') }}</li>
                            </div>
                        </figure>
                        </a>
                    </li>
                @endforeach
            </ul>
            <ul class="splide__pagination"></ul>
        </div>
    </div>
</section>

<section class="top10filmes">
    <div class="titulo-container">
        <h2 class="titulo">Top 10 Filmes</h2>
        <div class="slick-buttons">
            <button class="slick-prev">&#8249;</button>
            <button class="slick-next">&#8250;</button>
        </div>
    </div>
    <div class="slick-carousel">
        @foreach ($top10 as $index => $filme)
            <div class="filme">
                <a href="{{ route('filme.detail', ['id' => $filme->id]) }}">
                <div class="filme-info">
                    <span class="numero">{{ $index + 1 }}</span>
                    <img src="{{ $filme->poster_path }}" alt="{{ $filme->name }}">
                </div>
                </a>
            </div>
        @endforeach
    </div>
</section>


    <script src="https://cdn.jsdelivr.net/npm/@splidejs/splide@3.0.0/dist/js/splide.min.js"></script>
<script>
    document.addEventListener("DOMContentLoaded", function() {
        new Splide('#featured-slider', {
            type: 'loop', // Loop do slider
            perPage: 1,   // Quantidade de slides exibidos por vez
            autoplay: false,
            interval: 5000, // Tempo de cada slide (5 segundos)
        }).mount();
    });
</script>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.min.js"></script>

<script>
    $(document).ready(function(){
        $('.slick-carousel').slick({
            slidesToShow: 4,
            slidesToScroll: 4,
            arrows:true,
            autoplay: false,
            infinite: false,
            autoplaySpeed: 5000,
            nextArrow:'.slick-next',
            prevArrow:'.slick-prev',
            responsive: [
                {
                    breakpoint: 768,
                    settings: {
                        slidesToShow: 4
                    }
                },
                {
                    breakpoint: 480,
                    settings: {
                        slidesToShow: 3
                    }
                }
            ]
        });
    });
</script>

    
</body>
</html>