<!DOCTYPE html>
<html>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<head>
    <title>Filmes</title>
    <link rel="stylesheet" href="/public/css/web.css">
</head>
<body>

    @include('layouts._partials.header')

    <div class="container-series">
        <div class="series-list">
            @foreach ($movies as $movie)
                <div class="serie">
                    <a href="{{ route('filme.detail', $movie->id) }}">
                        <figure>
                            <img src="{{ $movie->poster_path }}" alt="{{ $movie->title }}">
                        </figure>
                    </a>
                </div>
            @endforeach
        </div>

        <div class="pagination">
                
                <span class="pagination-links">
                    @if ($movies->currentPage() > 1)
                        <a href="{{ $movies->previousPageUrl() }}">Anterior</a>
                    @endif

                    @for ($i = max(1, $movies->currentPage() - 1); $i <= min($movies->lastPage(), $movies->currentPage() + 1); $i++)
                        <a href="{{ $movies->url($i) }}" class="{{ $i === $movies->currentPage() ? 'active' : '' }}">{{ $i }}</a>
                    @endfor

                    @if ($movies->hasMorePages())
                        <a href="{{ $movies->nextPageUrl() }}">Próxima</a>
                    @endif
                </span>
            </div>
    </div>
</body>
</html>
