
const mp = new MercadoPago('APP_USR-fb1915e8-c40a-4559-8dc1-61ea62464382');
const bricksBuilder = mp.bricks();

const renderPaymentBrick = async (bricksBuilder) => {
  // Fazer a solicitação AJAX para obter o preferenceId
  const response = await axios.get('/pagamento');
  const { preferenceId } = response.data;

  const settings = {
    initialization: {
      amount: 100,
      preferenceId: preference,
    },
   customization: {
     paymentMethods: {
       ticket: "all",
       bankTransfer: "all",
       creditCard: "all",
       debitCard: "all",
       mercadoPago: "all",
     },
   },
   callbacks: {
     onReady: () => {
       /*
        Callback chamado quando o Brick estiver pronto.
        Aqui você pode ocultar loadings do seu site, por exemplo.
       */
     },
     onSubmit: ({ selectedPaymentMethod, formData }) => {
       // callback chamado ao clicar no botão de submissão dos dados
       return new Promise((resolve, reject) => {
         fetch("/pagamento", {
           method: "POST",
           headers: {
             "Content-Type": "application/json",
           },cr
           body: JSON.stringify(formData),
         })
           .then((response) => response.json())
           .then((response) => {
             // receber o resultado do pagamento
             resolve();
           })
           .catch((error) => {
             // lidar com a resposta de erro ao tentar criar o pagamento
             reject();
           });
       });
     },
     onError: (error) => {
       // callback chamado para todos os casos de erro do Brick
       console.error(error);
     },
   },
 };
 window.paymentBrickController = await bricksBuilder.create(
   "payment",
   "paymentBrick_container",
   settings
 );
};
renderPaymentBrick(bricksBuilder);
