<?php

namespace App\Services;

use Loilo\Fuse\Fuse;
use App\Movie;

class MovieSearchService
{
    public function searchMovies($query)
    {
        // Obtenha todos os filmes da tabela
        $allMovies = Movie::all();

        // Crie uma instância do Fuse com os dados dos filmes e opções de pesquisa
        $fuse = new Fuse($allMovies, [
            'keys' => ['title'],
            'threshold' => 0.4, // Ajuste isso conforme necessário para controlar a sensibilidade da pesquisa
        ]);

        // Realize a pesquisa fuzzy
        $results = $fuse->search($query);

        return $results;
    }
}
