<?php

namespace App\Rules;

use Elastic\ScoutDriverPlus\Builders\QueryBuilderInterface;
use Elastic\ScoutDriverPlus\Builders\SearchRequestBuilder;

class FuzzySearchRule implements QueryBuilderInterface
{
    private $query;

    public function __construct(string $query)
    {
        $this->query = $query;
    }

    public function buildQuery(): array
    {
        return [
            'multi_match' => [
                'query' => $this->query,
                'fields' => ['title', 'original_name'],
                'fuzziness' => 'AUTO',
            ],
        ];
    }
}
