<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class RedirectIfAuthenticated
{
    /**
     * Handle an incoming request.
     *
     * @param Request $request
     * @param Closure $next
     * @param string|null $guard
     * @return mixed
     */
    public function handle($request, Closure $next, $guard = null)
    {
        if (Auth::guard($guard)->check()) {
            $user = Auth::user();
    
            if ($user->device_token !== $request->session()->getId()) {
                Auth::logout();
                return redirect('/login')->with('error', 'Sua conta está sendo usada em outro dispositivo.');
            }
        }
    
        return $next($request);
}
}
