<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;

class CheckSingleDeviceLogin
{
    public function handle($request, Closure $next)
    {
        $user = Auth::user();

        if ($user->isLoggedOut($request->header('X-Device-Token'))) {
            Auth::logout();
            return response()->json(['error' => 'Sessão expirada. Faça login novamente.'], 401);
        }

        return $next($request);
    }
}
