<?php

namespace App\Http\Middleware;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Firebase\JWT\JWT;
use Firebase\JWT\Key;

class AuthenticateOptionally extends Authenticate
{
    public function handle(Request $request, Closure $next)
    {
        // Primeiro, tenta autenticar usando o guard padrão da API
        if (Auth::guard('api')->check()) {
            return $next($request);
        }

        // Se a autenticação da API falhar, tenta validar o token JWT
        $token = $request->bearerToken();
        if ($token) {
            try {
                $decoded = JWT::decode($token, new Key(env('JWT_SECRET'), 'HS256')); // Ajuste conforme sua chave e algoritmo
                
                // Aqui, você pode adicionar lógica adicional para verificar o usuário decodificado
                // e talvez até configurar manualmente o usuário autenticado no guard da aplicação

                // Se tudo estiver correto, permite que a requisição prossiga
                return $next($request);
            } catch (\Exception $e) {
                // Em caso de falha na validação do token, retorna um erro
                return response()->json(['error' => 'Token JWT inválido: ' . $e->getMessage()], 401);
            }
        }

        // Se nenhum método de autenticação for bem-sucedido, retorna um erro
        return response()->json(['error' => 'Não autenticado'], 401);
    }
}
