<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use MercadoPago;
use App\User;
use Illuminate\Support\Str;
use Illuminate\Foundation\Auth\VerifiesEmails;
use Illuminate\Support\Facades\DB;
use Laravel\Passport\Client;
use Illuminate\Support\Carbon;
use MercadoPago\Payment;
use Illuminate\Support\Facades\Http;


class WebhookController extends Controller
{
    public function __invoke(Request $request){
        
        $payload = $request->all();
        $requestSignature = $request->header('x-signature');

        // Verifique a assinatura da notificação
        if ($this->isValidSignature($payload, $requestSignature)) {
            $paymentId = $payload['id'];
            $paymentStatus = $payload['status'];

            // Atualize o status do pagamento no seu sistema
            if ($paymentStatus === 'approved') {
                // Chame a função pagamentoSucesso
                return $this->pagamentoSucesso($request);
            } elseif ($paymentStatus === 'pending') {
                // Lógica para pagamento pendente
            } elseif ($paymentStatus === 'rejected') {
                // Lógica para pagamento rejeitado
            }

            return response()->json(['success' => true]);
        }

        return response()->json(['success' => false, 'error' => 'Invalid signature'], 400);
        
    }
    
}
