<?php

namespace App\Http\Controllers;

use App\Season;



class SeasonController extends Controller
{
    // returns all episodes of a season
    public function show(Season $season)
    {


        $all = $season
            ->episodes()
            ->with('videos')
            ->get();


        return response()->json(['episodes' => $all], 200);


    }


    public function episodes($seasonId, $code)
{
    $season = Season::with('episodes.videos')->find($seasonId);

    if (!$season) {
        return response()->json(['message' => 'Temporada não encontrada'], 404);
    }

    // Aqui, `with('episodes.videos')` já carregou os episódios com seus vídeos,
    // então você pode simplesmente retornar os episódios da temporada.
    $episodes = $season->episodes;

    return response()->json(['episodes' => $episodes]);
}


    // delete a season from the database
    public function destroy(Season $season)
    {
        if ($season != null) {
            $season->delete();

            $data = [
                'status' => 200,
                'message' => 'successfully deleted',
            ];
        } else {
            $data = [
                'status' => 400,
                'message' => 'could not be deleted',
            ];
        }

        return response()->json($data, $data['status']);
    }
}
