<?php

namespace App\Http\Controllers;



use Illuminate\Http\Request;
use App\Movie;
use App\Serie;
use App\Livetv;
use App\Anime;
use App\User;
use App\Cast;
use BeyondCode\Comments\Comment;
use App\Setting;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use App\Services\MovieSearchService;

class SearchController extends Controller
{


    
    private function formatSearchString($string)
{
    // Separa palavras concatenadas por camelCase ou números
    $string = preg_replace('/([a-z])([A-Z])/', '$1 $2', $string); // Ex: xMen -> x Men
    $string = preg_replace('/([a-z])([0-9])/', '$1 $2', $string); // Ex: spiderman2020 -> spiderman 2020
    $string = preg_replace('/([0-9])([a-z])/', '$1 $2', $string); // Ex: 2020spiderman -> 2020 spiderman

    // Substitui hífens e outros caracteres especiais por espaços
    $specialCharsPattern = '/[-_.,!@#$%^&*()+={}\[\]|:;"<>?\/\\\\]/';
    $formattedSearch = preg_replace($specialCharsPattern, ' ', $string);

    // Remove múltiplos espaços e espaços no início e fim
    $formattedSearch = preg_replace('/\s+/', ' ', $formattedSearch);
    $formattedSearch = trim($formattedSearch);

    return $formattedSearch;
}

private function getFormattedSearchConditions($searchString, ...$fields)
{
    $formattedSearch = $this->formatSearchString($searchString);
    $words = explode(' ', $formattedSearch);

    $allFieldConditions = [];
    foreach ($fields as $field) {
        $fieldConditions = [];
        foreach ($words as $word) {
            // Utiliza funções SQL para transformar os campos e termos em minúsculas e substituir hífens por espaços
            $fieldConditions[] = 'LOWER(REPLACE(' . $field . ', "-", " ")) LIKE ' . "'%" . mb_strtolower($word) . "%'";
        }
        $allFieldConditions[] = '(' . implode(' AND ', $fieldConditions) . ')';
    }

    return implode(' OR ', $allFieldConditions);
}



// returns all the movies, animes and livetv that match the search
public function index($query, $code, $page = 1)
{
    $limit = 15;
    $offset = ($page - 1) * $limit;

    // Formatação do termo de busca
    $formattedSearch = $this->formatSearchString($query);

    $selectMovie = [
        'id', 'title AS name', 'poster_path', 'original_name', 'backdrop_path',
        'backdrop_path_tv', 'vote_average', 'subtitle', 'overview', 'release_date', 'pinned',
        'created_at', 'updated_at', 'views', DB::raw("'movie' AS type")
    ];

    $selectSerie = [
        'id', 'name', 'poster_path', 'original_name', 'backdrop_path',
        'backdrop_path_tv', 'vote_average', 'subtitle', 'overview', 'first_air_date AS release_date',
        'pinned', 'created_at', 'updated_at', 'views', DB::raw("'serie' AS type")
    ];

    $selectAnime = [
        'id', 'name', 'poster_path', 'original_name', 'backdrop_path',
        'backdrop_path_tv', 'vote_average', 'subtitle', 'overview', 'first_air_date AS release_date', 
        'pinned', 'created_at', 'updated_at', 'views', DB::raw("'anime' AS type")
    ];

    // Buscando em Movies
    $movieResults = Movie::select($selectMovie)
        ->where('active', 1)
        ->whereFuzzy('title', $formattedSearch)
        ->orWhereFuzzy('original_name', $formattedSearch)
        ->orderByFuzzy(['title', 'original_name'])
        ->offset($offset)
        ->limit($limit)
        ->get();

    // Buscando em Series
    $serieResults = Serie::select($selectSerie)
        ->where('active', 1)
        ->whereFuzzy('name', $formattedSearch)
        ->orWhereFuzzy('original_name', $formattedSearch)
        ->orderByFuzzy(['name', 'original_name'])
        ->offset($offset)
        ->limit($limit)
        ->get();

    // Buscando em Animes
    $animeResults = Anime::select($selectAnime)
        ->where('active', 1)
        ->whereFuzzy('name', $formattedSearch)
        ->orWhereFuzzy('original_name', $formattedSearch)
        ->orderByFuzzy(['name', 'original_name'])
        ->offset($offset)
        ->limit($limit)
        ->get();

    $movieResults->makeHidden(['casterslist', 'casters', 'genres', 'videos', 'substitles', 'downloads', 'genresname', 'networkslist', 'substype', 'networks' ]);
    $serieResults->makeHidden(['casterslist', 'casters', 'genres', 'videos', 'substitles', 'downloads', 'genresname', 'networkslist', 'substype', 'networks', 'seasons', 'genreslist'  ]);
    $animeResults->makeHidden(['casterslist', 'casters', 'genres', 'videos', 'substitles', 'downloads', 'genresname', 'networkslist', 'substype', 'networks', 'seasons', 'genreslist' ]);
    $combinedResults = $movieResults->concat($serieResults)->concat($animeResults);

    return response()->json(['search' => $combinedResults, 'page' => $page, 'limit' => $limit], 200);
}


public function searchMovies()
{
    $query = \Request::get('q');
    $page = \Request::get('page', 1);
    $limit = 15;
    $offset = ($page - 1) * $limit;
    
    $specialCharsPattern = '/[-_.,!@#$%^&*()+={}\[\]|:;"<>?\/\\\\]/';

    $formattedQuery = preg_replace($specialCharsPattern, ' ', $query);
    $formattedQuery = preg_replace('/\s+/', ' ', $formattedQuery);

    // Formatação do termo de busca
    $formattedSearch = $this->formatSearchString($formattedQuery);

    $selectFields = [
        'id', 'title', 'poster_path', 'premuim', 'active', 'original_name', 'backdrop_path', 'tmdb_id',
        'backdrop_path_tv', 'vote_average', 'subtitle', 'overview', 'release_date', 'pinned',
        'created_at', 'updated_at', 'views', DB::raw("'movie' AS type")
    ];

    // Buscando em Movies
    $movieResults = Movie::select($selectFields)
        ->whereFuzzy('title', $formattedSearch)
        ->orWhereFuzzy('original_name', $formattedSearch)
        ->orderByFuzzy(['title', 'original_name'])
        ->offset($offset)
        ->limit($limit)
        ->get();


    return response()->json(['movies' => $movieResults, 'page' => $page, 'limit' => $limit], 200);
}


public function searchSeries()
    {
    	$query = \Request::get('q');
    $page = \Request::get('page', 1);
    $limit = 15;
    $offset = ($page - 1) * $limit;
    
    $specialCharsPattern = '/[-_.,!@#$%^&*()+={}\[\]|:;"<>?\/\\\\]/';

    $formattedQuery = preg_replace($specialCharsPattern, ' ', $query);
    $formattedQuery = preg_replace('/\s+/', ' ', $formattedQuery);

    // Formatação do termo de busca
    $formattedSearch = $this->formatSearchString($formattedQuery);

    $selectFields = [
        'id', 'name', 'poster_path', 'premuim', 'active', 'original_name', 'backdrop_path', 'tmdb_id',
        'backdrop_path_tv', 'vote_average', 'subtitle', 'overview', 'first_air_date', 'pinned',
        'created_at', 'updated_at', 'views', DB::raw("'serie' AS type")
    ];

    // Buscando em Movies
    $movieResults = Serie::select($selectFields)
        ->whereFuzzy('name', $formattedSearch)
        ->orWhereFuzzy('original_name', $formattedSearch)
        ->orderByFuzzy(['name', 'original_name'])
        ->offset($offset)
        ->limit($limit)
        ->get();


    return response()->json(['series' => $movieResults, 'page' => $page, 'limit' => $limit], 200);
    }




    public function indexweb(Request $request)
    {
        $search = $request->input('search');
        $searchResults = [];

        $settings = Setting::query()->first();

        if ($search) {
            $genresMovies =
        DB::raw('(SELECT SUBSTRING_INDEX(GROUP_CONCAT(genres.name SEPARATOR ", "), ",", 1)
        FROM genres JOIN movie_genres ON genres.id = movie_genres.genre_id WHERE movie_genres.movie_id = movies.id)
        AS genre_name');

        $genresSeries =
        DB::raw('(SELECT SUBSTRING_INDEX(GROUP_CONCAT(genres.name SEPARATOR ", "), ",", 1)
        FROM genres JOIN serie_genres ON genres.id = serie_genres.genre_id WHERE serie_genres.serie_id = series.id) AS genre_name');

        $genresAnimes =
        DB::raw('(SELECT SUBSTRING_INDEX(GROUP_CONCAT(genres.name SEPARATOR ", "), ",", 1)
        FROM genres JOIN anime_genres ON genres.id = anime_genres.genre_id WHERE anime_genres.anime_id = animes.id) AS genre_name');


        $selectMovie = [
            'id', 'title AS name', 'poster_path', 'backdrop_path',
                    'backdrop_path_tv', 'vote_average', 'subtitle', 'overview', 'release_date', 'pinned',
                    'created_at','updated_at', 'views', DB::raw("'movie' AS type")
        ];

        $selectSerie = [
            'id', 'name', 'poster_path', 'backdrop_path',
                        'backdrop_path_tv', 'vote_average', 'subtitle', 'overview', 'first_air_date AS release_date',
                        'pinned', 'created_at','updated_at', 'views', DB::raw("'serie' AS type")
        ];


        $selectAnime = [
            'id', 'name', 'poster_path', 'backdrop_path',
                    'backdrop_path_tv', 'vote_average', 'subtitle', 'overview', 'first_air_date AS release_date', 
                    'pinned', 'created_at','updated_at','views', DB::raw("'anime' AS type")
        ];


        if($settings->anime){


            $searhQuery = DB::table(function ($query) use ($selectMovie,$selectSerie,$selectAnime,$selectLive,
            $genresMovies,$genresSeries,$genresAnimes,$genresLive,$search) {
                $query->where('title', 'LIKE', '%'.$search.'%')->select(array_merge(
                    $selectMovie,
                    [
                        $genresMovies,
                    ]
                ))
                    ->from('movies')
                    ->where('active', '=', 1)
                    ->orderBy('created_at', 'desc')
                    ->limit(10);
    
                $query->unionAll(function ($query) use ($selectSerie,$genresSeries,$search) {
                    $query->where('name', 'LIKE', '%'.$search.'%')->select(array_merge(
                        $selectSerie,
                        [
                            $genresSeries,
                        ]
                    ))
                        ->from('series')
                        ->where('active', '=', 1)
                        ->orderBy('created_at', 'desc')
                        ->limit(10);
                });
    
                $query->unionAll(function ($query) use ($selectAnime,$genresAnimes,$search) {
                    $query->where('name', 'LIKE', '%'.$search.'%')->select(array_merge(
                        $selectAnime,
                        [
                            $genresAnimes,
                        ]
                    ))
                        ->from('animes')
                        ->where('active', '=', 1)
                        ->orderBy('created_at', 'desc')
                        ->limit(10);
                });
            })
                 ->orderByDesc('created_at')
                ->get();

        }else {


            $searhQuery = DB::table(function ($query) use ($selectMovie,$selectSerie,$selectAnime,$selectLive,
            $genresMovies,$genresSeries,$genresAnimes,$genresLive,$search) {
                $query->where('title', 'LIKE', '%'.$search.'%')->select(array_merge(
                    $selectMovie,
                    [
                        $genresMovies,
                    ]
                ))
                    ->from('movies')
                    ->where('active', '=', 1)
                    ->orderBy('created_at', 'desc')
                    ->limit(10);
    
                $query->unionAll(function ($query) use ($selectSerie,$genresSeries,$search) {
                    $query->where('name', 'LIKE', '%'.$search.'%')->select(array_merge(
                        $selectSerie,
                        [
                            $genresSeries,
                        ]
                    ))
                        ->from('series')
                        ->where('active', '=', 1)
                        ->orderBy('created_at', 'desc')
                        ->limit(10);
                });
            })
                 ->orderByDesc('created_at')
                ->get();
        }

        if ($settings->anime) {
            $searchResults = $searhQuery;
        } else {
            $searchResults = $searhQuery;
        }
        }
    

        $suggestedMovies = Movie::where('active', 1)->inRandomOrder()->limit(12)->get();
        $suggestedSeries = Serie::where('active', 1)->inRandomOrder()->limit(12)->get();
        $suggestedAnimes = Anime::where('active', 1)->inRandomOrder()->limit(6)->get();

        return view('pesquisa', [
            'searchResults' => $searchResults,
            'search' => $search,
            'suggestedMovies' => $suggestedMovies,
            'suggestedSeries' => $suggestedSeries,
            'suggestedAnimes' => $suggestedAnimes,
        ]);
    }
    
    public function realtimeSearch(Request $request)
{
    $search = $request->input('search');
    $searchResults = [];

    $settings = Setting::query()->first();

        if ($search) {
            $genresMovies =
        DB::raw('(SELECT SUBSTRING_INDEX(GROUP_CONCAT(genres.name SEPARATOR ", "), ",", 1)
        FROM genres JOIN movie_genres ON genres.id = movie_genres.genre_id WHERE movie_genres.movie_id = movies.id)
        AS genre_name');

        $genresSeries =
        DB::raw('(SELECT SUBSTRING_INDEX(GROUP_CONCAT(genres.name SEPARATOR ", "), ",", 1)
        FROM genres JOIN serie_genres ON genres.id = serie_genres.genre_id WHERE serie_genres.serie_id = series.id) AS genre_name');

        $genresAnimes =
        DB::raw('(SELECT SUBSTRING_INDEX(GROUP_CONCAT(genres.name SEPARATOR ", "), ",", 1)
        FROM genres JOIN anime_genres ON genres.id = anime_genres.genre_id WHERE anime_genres.anime_id = animes.id) AS genre_name');


        $selectMovie = [
            'id', 'title AS name', 'poster_path', 'backdrop_path',
                    'backdrop_path_tv', 'vote_average', 'subtitle', 'overview', 'release_date', 'pinned',
                    'created_at','updated_at', 'views', DB::raw("'movie' AS type")
        ];

        $selectSerie = [
            'id', 'name', 'poster_path', 'backdrop_path',
                        'backdrop_path_tv', 'vote_average', 'subtitle', 'overview', 'first_air_date AS release_date',
                        'pinned', 'created_at','updated_at', 'views', DB::raw("'serie' AS type")
        ];


        $selectAnime = [
            'id', 'name', 'poster_path', 'backdrop_path',
                    'backdrop_path_tv', 'vote_average', 'subtitle', 'overview', 'first_air_date AS release_date', 
                    'pinned', 'created_at','updated_at','views', DB::raw("'anime' AS type")
        ];


        if($settings->anime){


            $searhQuery = DB::table(function ($query) use ($selectMovie,$selectSerie,$selectAnime,$selectLive,
            $genresMovies,$genresSeries,$genresAnimes,$genresLive,$search) {
                $query->where('title', 'LIKE', '%'.$search.'%')->select(array_merge(
                    $selectMovie,
                    [
                        $genresMovies,
                    ]
                ))
                    ->from('movies')
                    ->where('active', '=', 1)
                    ->orderBy('created_at', 'desc')
                    ->limit(10);
    
                $query->unionAll(function ($query) use ($selectSerie,$genresSeries,$search) {
                    $query->where('name', 'LIKE', '%'.$search.'%')->select(array_merge(
                        $selectSerie,
                        [
                            $genresSeries,
                        ]
                    ))
                        ->from('series')
                        ->where('active', '=', 1)
                        ->orderBy('created_at', 'desc')
                        ->limit(10);
                });
    
                $query->unionAll(function ($query) use ($selectAnime,$genresAnimes,$search) {
                    $query->where('name', 'LIKE', '%'.$search.'%')->select(array_merge(
                        $selectAnime,
                        [
                            $genresAnimes,
                        ]
                    ))
                        ->from('animes')
                        ->where('active', '=', 1)
                        ->orderBy('created_at', 'desc')
                        ->limit(10);
                });
            })
                 ->orderByDesc('created_at')
                ->get();

        }else {


            $searhQuery = DB::table(function ($query) use ($selectMovie,$selectSerie,$selectAnime,$selectLive,
            $genresMovies,$genresSeries,$genresAnimes,$genresLive,$search) {
                $query->where('title', 'LIKE', '%'.$search.'%')->select(array_merge(
                    $selectMovie,
                    [
                        $genresMovies,
                    ]
                ))
                    ->from('movies')
                    ->where('active', '=', 1)
                    ->orderBy('created_at', 'desc')
                    ->limit(10);
    
                $query->unionAll(function ($query) use ($selectSerie,$genresSeries,$search) {
                    $query->where('name', 'LIKE', '%'.$search.'%')->select(array_merge(
                        $selectSerie,
                        [
                            $genresSeries,
                        ]
                    ))
                        ->from('series')
                        ->where('active', '=', 1)
                        ->orderBy('created_at', 'desc')
                        ->limit(10);
                });
            })
                 ->orderByDesc('created_at')
                ->get();
        }

        if ($settings->anime) {
            $searchResults = $searhQuery;
        } else {
            $searchResults = $searhQuery;
        }
        }

    return view('realtime_search_results', [
        'searchResults' => $searchResults,
    ]);
}





    public function searchFeatured()
    {

        $query = \Request::get('q');
    	$movies = Movie::select('*')->whereRaw("title LIKE '%" . $query . "%'")
        ->orWhereRaw("original_name LIKE '%" . $query . "%'")
        ->where('active', '=', 1)
        ->addSelect(DB::raw("'Movie' as type"))->limit(50)->get();

        $series = Serie::select('*')->whereRaw("name LIKE '%" . $query . "%'")
        ->orWhereRaw("original_name LIKE '%" . $query . "%'")->where('active', '=', 1)
        ->addSelect(DB::raw("'Serie' as type"))->limit(50)->get();


        $anime = Anime::select('*')->whereRaw("name LIKE '%" . $query . "%'")
        ->orWhereRaw("original_name LIKE '%" . $query . "%'")->where('active', '=', 1)
        ->addSelect(DB::raw("'Anime' as type"))->limit(50)->get();

        $livetv = Livetv::select('*')->whereRaw("name LIKE '%" . $query . "%'")
        ->addSelect(DB::raw("'Streaming' as type"))->limit(50)->get();

        $array = array_merge($movies->toArray(),
         $series->toArray()
         ,$anime->makeHidden('seasons','episodes')->toArray(),$livetv->toArray());

        return response()->json(['search' => $array], 200);

    }



    public function searchCasts()
    {
    	$query = \Request::get('q');

        $casts = Cast::select('*')->where('name', 'LIKE', "%$query%")->limit(50)->get();

    	return response()->json([ 'casts' => $casts ],Response::HTTP_OK);
    }


    public function searchComments()
    {
    	$query = \Request::get('q');

        $comments = Comment::select('*')->where('comment', 'LIKE', "%$query%")->limit(50)->get();

    	return response()->json([ 'comments' => $comments ],Response::HTTP_OK);
    }



    
    public function searchAnimes()
    {
    	{
            $query = \Request::get('q');
        $page = \Request::get('page', 1);
        $limit = 15;
        $offset = ($page - 1) * $limit;
        
        $specialCharsPattern = '/[-_.,!@#$%^&*()+={}\[\]|:;"<>?\/\\\\]/';
    
        $formattedQuery = preg_replace($specialCharsPattern, ' ', $query);
        $formattedQuery = preg_replace('/\s+/', ' ', $formattedQuery);
    
        // Formatação do termo de busca
        $formattedSearch = $this->formatSearchString($formattedQuery);
    
        $selectFields = [
            'id', 'name', 'poster_path', 'active', 'original_name', 'backdrop_path', 'tmdb_id',
            'backdrop_path_tv', 'vote_average', 'subtitle', 'overview', 'first_air_date', 'pinned',
            'created_at', 'updated_at', 'views', DB::raw("'serie' AS type")
        ];
    
        // Buscando em Movies
        $movieResults = Anime::select($selectFields)
            ->whereFuzzy('name', $formattedSearch)
            ->orWhereFuzzy('original_name', $formattedSearch)
            ->orderByFuzzy(['name', 'original_name'])
            ->offset($offset)
            ->limit($limit)
            ->get();
    
    
        return response()->json(['animes' => $movieResults, 'page' => $page, 'limit' => $limit], 200);
        }
    }



    public function searchStreaming()
    {
    	$query = \Request::get('q');
        $movies = Livetv::select('*')->where('name', 'LIKE', "%$query%")->limit(10)->get();

    	return response()->json([ 'streaming' => $movies ],Response::HTTP_OK);
    }

    public function searchUsers()
    {
    	$query = \Request::get('q');
        $movies = User::select('*')->where('email', 'LIKE', "%$query%")->get();

    	return response()->json([ 'users' => $movies ],Response::HTTP_OK);
    }

    public function getRandomContent()
{
    $movies = Movie::where('active', 1)->inRandomOrder()->limit(5)->get([
        'id', 'tmdb_id', 'title as name', 'poster_path', 'backdrop_path', 'overview'
    ])->map(function ($movie) {
        $movie->type = 'filme';
        return $movie;
    });

    $series = Serie::where('active', 1)->inRandomOrder()->limit(5)->get([
        'id', 'tmdb_id', 'name', 'poster_path', 'backdrop_path', 'overview'
    ])->map(function ($serie) {
        $serie->type = 'serie';
        return $serie;
    });

    $animes = Anime::where('active', 1)->inRandomOrder()->limit(5)->get([
        'id', 'tmdb_id', 'name', 'poster_path', 'backdrop_path', 'overview'
    ])->map(function ($anime) {
        $anime->type = 'anime';
        return $anime;
    });

    $content = $movies->concat($series)->concat($animes);

    // Ajuste dos dados para uniformizar a estrutura e incluir o tipo
    $content = $content->map(function ($item) {
        return [
            'id' => $item->id,
            'tmdb_id' => $item->tmdb_id,
            'name' => $item->name,
            'poster_path' => $item->poster_path,
            'backdrop_path' => $item->backdrop_path,
            'overview' => $item->overview,
            'type' => $item->type // Incluir o tipo aqui
        ];
    });

    return response()->json(['suggestions' => $content], 200);
}




}