<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User; // Asegure-se de que a User model está sendo usada se necessário
use Illuminate\Support\Facades\Cache; // Usando o cache para salvar temporariamente os códigos

class QrCodeController extends Controller
{
    public function generateCode()
    {
        $code = rand(100000, 999999); // Gera um código aleatório
        Cache::put($code, true, 300); // Salva o código no cache por 5 minutos
        return response()->json(['code' => $code]);
    }

    public function verifyCode(Request $request)
    {
        $code = $request->input('code');
        if (Cache::pull($code)) { // Verifica se o código existe e remove do cache
            // A autenticação foi bem-sucedida
            return response()->json(['success' => true]);
        } else {
            // A autenticação falhou
            return response()->json(['success' => false], 401);
        }
    }
}
