<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\User;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Carbon;
use MercadoPago\MercadoPagoConfig;
use MercadoPago\Client\Preference\PreferenceClient;
use MercadoPago\Exceptions\MPApiException;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Hash;


class MercadoPagoController extends Controller
{
    

    
    protected function authenticate()
    {
        $mpAccessToken = env('MERCADOPAGO_ACCESS_TOKEN');
        MercadoPagoConfig::setAccessToken($mpAccessToken);
    
    }

    protected function realizarPagamento($items, $payer, $email): array
    {
        $paymentMethods = [
            "excluded_payment_methods" => [],
            "installments" => 12,
            "default_installments" => 1
        ];

        $backUrls = array(
            'success' => 'https://site.ultraflix.net/public/pagamento/sucesso',
            'failure' => 'https://site.ultraflix.net/public/pagamento/falha',
            'pending' => 'https://site.ultraflix.net/public/pagamento/pendente',
        );

        $request = [
            "items" => $items,
            "payer" => $payer,
            "payment_methods" => $paymentMethods,
            "back_urls" => $backUrls,
            "statement_descriptor" => "ULTRAFLIX",
            "external_reference" => $email,
            "expires" => false,
            "notification_url" => 'https://site.ultraflix.net/public/webhook/mercadopago',
            "auto_return" => 'approved',
            "metadata" => [
                'cliente' => array($payer),
                'items' => $items,
            ]
        ];

        return $request;
    }

    public function createPaymentPreference(Request $request)
    {
        $this->authenticate();

        
        $email = $request->input('email');
        $nome = $request->input('name');
        $numero = $request->input('numero');

        $planoSelecionado = $request->input('plano');

        // Mapeamento dos planos com seus respectivos preços e durações
        $planos = [
            'plano1' => ['preco' => 6.0, 'dias' => 15],
            'plano2' => ['preco' => 10.0, 'dias' => 30],
            'plano5' => ['preco' => 16.0, 'dias' => 60],
            'plano3' => ['preco' => 25.0, 'dias' => 90],
            // Adicione mais planos conforme necessário
        ];

        if (!array_key_exists($planoSelecionado, $planos)) {
            return back()->withErrors(['mensagem' => 'Plano selecionado é inválido.']);
        }

        // Configuração dos itens baseada no plano escolhido
        $items = [
            [
                "title" => "Assinatura - " . $planos[$planoSelecionado]['dias'] . " Dias",
                "quantity" => 1,
                "currency_id" => "BRL",
                "unit_price" => $planos[$planoSelecionado]['preco'],
                "description" => $planos[$planoSelecionado]['dias']
            ]
        ];

        $payer = [
            "email" => $email,
            "first_name" => $nome,
            "number" => $numero

        ];

        $request = $this->realizarPagamento($items, $payer, $email);

        $client = new PreferenceClient();

        try {
            $preference = $client->create($request);
            return redirect($preference->init_point);
        } catch (MPApiException $error) {
            // Tratamento de erro
            return response()->json(['error' => $error->getMessage()], 500);
        }
    }



public function pagamentoSucesso(Request $request)
{
    $url = $request->fullUrl(); // Obtém a URL completa da requisição
    $parsedUrl = parse_url($url); // Faz o parsing da URL
    $queryParams = [];
    parse_str($parsedUrl['query'], $queryParams); // Obtém os parâmetros da query string

    if (isset($queryParams['collection_id'])) {
        $collectionId = $queryParams['collection_id'];
        $accessToken = env('MERCADOPAGO_ACCESS_TOKEN');
        $url = "https://api.mercadopago.com/v1/payments/{$collectionId}?access_token={$accessToken}";

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $response = curl_exec($ch);
        $statusCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

        curl_close($ch);

        if ($statusCode == 200) {
            $payment = json_decode($response, true);

            if ($payment['status'] == 'approved') {
                $email = $payment['external_reference'];
                $category_id = null;
            
        
            
            if (isset($payment['additional_info']['items']) && is_array($payment['additional_info']['items'])) {
                foreach ($payment['additional_info']['items'] as $item) {
                    if (isset($item['category_id'])) {
                        $category_id = $item['category_id'];
                        break;
                    }
                }
            }
            
            if ($category_id !== null) {
                $usuario = User::where('email', $email)->first();
            
                if ($usuario) {
                    // Se o usuário existir, atualize suas informações
                    $usuario->premuim = true;
                    $usuario->expired_in = Carbon::now()->addDays($category_id);
                } else {
                    // Se o usuário não existir, crie um novo com uma senha aleatória
                    $randomPassword = Str::random(6);
                    $usuario = new User([
                        'email' => $email,
                        'name' => 'Usuário',
                        'password' => Hash::make($randomPassword), // Senha criptografada
                        'premuim' => true,
                        'expired_in' => Carbon::now()->addDays($category_id),
                    ]);
            
                    // Envie a senha para o e-mail do usuário
                    Mail::send('emails.password', ['password' => $randomPassword], function ($message) use ($email) {
                        $message->to($email)->subject('Sua senha temporária');
                    });
                }
            
                $usuario->save();
                return view('sucesso');
            } else {
                    // Renderizar a view pendente e iniciar a atualização a cada 3 segundos
                    echo "<script>
                            setTimeout(function(){
                                location.reload();
                            }, 3000);
                          </script>";
                    return view('pendente');
                }
            }
    
        }
    }
  
}

    
    public function handleMercadoPagoWebhook(Request $request)
{
    $url = $request->fullUrl(); // Obtém a URL completa da requisição
    $parsedUrl = parse_url($url); // Faz o parsing da URL
    $queryParams = [];
    parse_str($parsedUrl['query'], $queryParams); // Obtém os parâmetros da query string

    if (isset($queryParams['id'])) {
        $collectionId = $queryParams['id'];
        $accessToken = env('MERCADOPAGO_ACCESS_TOKEN');
        $url = "https://api.mercadopago.com/v1/payments/{$collectionId}?access_token={$accessToken}";

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $response = curl_exec($ch);
        $statusCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

        curl_close($ch);

        if ($statusCode == 200) {
            $payment = json_decode($response, true);
    
            
            if ($payment['status'] == 'approved') {
                if (isset($payment['metadata']['cliente'][0]['email'])) {
                    $email = $payment['metadata']['cliente'][0]['email']; 
                } else {
                    return response()->json(['error' => 'Email não encontrado na metadata'], 422);
                }

                if (isset($payment['metadata']['cliente'][0]['first_name'])) {
                    $nome = $payment['metadata']['cliente'][0]['first_name']; 
                } else {
                    return response()->json(['error' => 'Email não encontrado na metadata'], 422);
                }

                if (isset($payment['metadata']['cliente'][0]['number'])) {
                    $numero = $payment['metadata']['cliente'][0]['number']; 
                } else {
                    return response()->json(['error' => 'Email não encontrado na metadata'], 422);
                }
            
                if (isset($payment['metadata']['items'][0]['description'])) {
                    $dias = $payment['metadata']['items'][0]['description'];
                } else {
                    return response()->json(['error' => 'Descrição não encontrada na metadata'], 422);
                }
            
                $usuario = DB::table('users')->where('email', '=', $email)->first();
            
                if ($usuario) {
                    // Se o usuário existir, atualize suas informações
                    DB::table('users')
                        ->where('email', '=', $email)
                        ->update([
                            "premuim" => true,
                            'whatsapp' => $numero,
                            "expired_in" => Carbon::now()->addDays($dias)
                        ]);
                } else {
                    // Se o usuário não existir, crie um novo com uma senha aleatória
                    $randomPassword = Str::random(6);
                    $usuario = new User([
                        'email' => $email,
                        'name' => $nome,
                        'whatsapp' => $numero,
                        'password' => Hash::make($randomPassword), // Senha criptografada
                        'premuim' => true,
                        'expired_in' => Carbon::now()->addDays($dias),
                    ]);

                    $usuario->save();
            
                }
            
                return response()->json('sucesso', 200);
            }
        }
    }
}

    public function pagamentoPendente(Request $request)
    {
        $url = $request->fullUrl(); // Obtém a URL completa da requisição
        $parsedUrl = parse_url($url); // Faz o parsing da URL
        $queryParams = [];
        parse_str($parsedUrl['query'], $queryParams); // Obtém os parâmetros da query string
    
        if (isset($queryParams['collection_id'])) {
            $collectionId = $queryParams['collection_id'];
            $accessToken = env('MERCADOPAGO_ACCESS_TOKEN');
            $url = "https://api.mercadopago.com/v1/payments/{$collectionId}?access_token={$accessToken}";
    
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    
            $response = curl_exec($ch);
            $statusCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    
            curl_close($ch);
    
            if ($statusCode == 200) {
                $payment = json_decode($response, true);
    
                if ($payment['status'] == 'approved') {
                    $email = $payment['external_reference'];
                    $category_id = null;
                
            
                
                if (isset($payment['additional_info']['items']) && is_array($payment['additional_info']['items'])) {
                    foreach ($payment['additional_info']['items'] as $item) {
                        if (isset($item['category_id'])) {
                            $category_id = $item['category_id'];
                            break;
                        }
                    }
                }
                
                if ($category_id !== null) {
                    $usuario = User::where('email', $email)->first();
                
                    if ($usuario) {
                        // Se o usuário existir, atualize suas informações
                        $usuario->premuim = true;
                        $usuario->expired_in = Carbon::now()->addDays($category_id);
                    } else {
                        // Se o usuário não existir, crie um novo com uma senha aleatória
                        $randomPassword = Str::random(6);
                        $usuario = new User([
                            'email' => $email,
                            'name' => 'Usuário',
                            'password' => Hash::make($randomPassword), // Senha criptografada
                            'premuim' => true,
                            'expired_in' => Carbon::now()->addDays($category_id),
                        ]);
                
                        // Envie a senha para o e-mail do usuário
                        Mail::send('emails.password', ['password' => $randomPassword], function ($message) use ($email) {
                            $message->to($email)->subject('Sua senha temporária');
                        });
                    }
                
                    $usuario->save();
                    return view('sucesso');
                } else {
                        // Renderizar a view pendente e iniciar a atualização a cada 3 segundos
                        echo "<script>
                                setTimeout(function(){
                                    location.reload();
                                }, 3000);
                              </script>";
                        return view('pendente');
                    }
                }
        
            }
        }
      
    }
    
    
     public function pagamentoFalha()
    {
        return view('falha');
    }

    public function showChoosePlan() {
        return view('layouts.choose_plan');
    }
}

