<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Episode;
use App\Network;
use App\MovieNetwork;
use App\Setting;
use App\Upcoming;
use Illuminate\Support\Facades\Auth;
use App\Genre;
use App\Cast;
use App\Http\Requests\MovieStoreRequest;
use App\Http\Requests\MovieUpdateRequest;
use App\Http\Requests\StoreImageRequest;
use App\Jobs\SendNotification;
use App\Movie;
use App\MovieGenre;
use App\MovieSubstitle;
use App\MovieVideo;
use App\MovieDownload;
use App\MovieCast;
use App\Serie;
use App\Anime;
use App\Livetv;
use App\Setting as SettingAlias;
use App\User;
use App\Featured;
use Illuminate\Http\Response;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\File;
use App\Http\ClearsResponseCache;
use ChristianKuri\LaravelFavorite\Traits\Favoriteable;
use BeyondCode\Comments\Comment;
use Illuminate\Validation\ValidationException;
use Spatie\Ray\Ray;

class InicioController extends Controller
{
    public function index()
    {



        $selectAnimeEpisodes =  ['anime_videos.anime_episode_id','animes.id'
        ,'animes.name','anime_episodes.still_path','anime_episodes.anime_season_id','anime_episodes.name as episode_name','anime_videos.link','anime_videos.server','anime_videos.lang'
        ,'anime_videos.embed','anime_videos.youtubelink','anime_videos.hls','anime_seasons.name as seasons_name','anime_seasons.season_number','anime_episodes.vote_average'
        ,'animes.premuim','animes.tmdb_id','anime_episodes.episode_number','animes.poster_path',
        'anime_episodes.hasrecap',
        'anime_episodes.skiprecap_start_in','anime_videos.supported_hosts'
        ,'anime_videos.drmuuid','anime_videos.drmlicenceuri','anime_videos.drm'];




        $selectSerieEpisodes =  [  'serie_videos.episode_id','series.id','series.tmdb_id as serieTmdb'
        ,'series.name','episodes.still_path','episodes.season_id','episodes.name as episode_name','serie_videos.link','serie_videos.server','serie_videos.lang'
        ,'serie_videos.embed','serie_videos.youtubelink','serie_videos.hls','seasons.name as seasons_name','seasons.season_number','episodes.vote_average'
        ,'series.premuim','episodes.episode_number','series.poster_path','episodes.hasrecap','episodes.skiprecap_start_in'
        ,'serie_videos.supported_hosts','serie_videos.header','serie_videos.useragent','series.imdb_external_id'
        ,'serie_videos.drmuuid','serie_videos.drmlicenceuri','serie_videos.drm'];

        $genresMovies =
        DB::raw('(SELECT SUBSTRING_INDEX(GROUP_CONCAT(genres.name SEPARATOR ", "), ",", 1)
        FROM genres JOIN movie_genres ON genres.id = movie_genres.genre_id WHERE movie_genres.movie_id = movies.id)
        AS genre_name');

        $genresSeries =
        DB::raw('(SELECT SUBSTRING_INDEX(GROUP_CONCAT(genres.name SEPARATOR ", "), ",", 1)
        FROM genres JOIN serie_genres ON genres.id = serie_genres.genre_id WHERE serie_genres.serie_id = series.id) AS genre_name');

        $genresAnimes =
        DB::raw('(SELECT SUBSTRING_INDEX(GROUP_CONCAT(genres.name SEPARATOR ", "), ",", 1)
        FROM genres JOIN anime_genres ON genres.id = anime_genres.genre_id WHERE anime_genres.anime_id = animes.id) AS genre_name');

        $selectMovie = [
            'id', 'title AS name', 'poster_path', 'backdrop_path',
                    'backdrop_path_tv', 'vote_average', 'subtitle', 'overview', 'release_date', 'pinned',
                    'created_at','updated_at', 'views', DB::raw("'movie' AS type")
        ];

        $selectSerie = [
            'id', 'name', 'poster_path', 'backdrop_path',
                        'backdrop_path_tv', 'vote_average', 'subtitle', 'overview', 'first_air_date AS release_date',
                        'pinned', 'created_at','updated_at', 'views', DB::raw("'serie' AS type")
        ];


        $selectAnime = [
            'id', 'name', 'poster_path', 'backdrop_path',
                    'backdrop_path_tv', 'vote_average', 'subtitle', 'overview', 'first_air_date AS release_date', 
                    'pinned', 'created_at','updated_at','views', DB::raw("'anime' AS type")
        ];

        $settings = Setting::query()->first();
            
            
            $genre = 10776;
            $genremarvel = 10773;
          
          if($settings->anime){

            $novelas = DB::table(function ($query) use ($genre) {
                $query->select('movies.id', 'title AS name', 'poster_path', 'backdrop_path', 
                'backdrop_path_tv', 'vote_average', 'subtitle', 'overview', 'release_date', 'pinned',
                 'movies.created_at', 'views', DB::raw("'movie' AS type"))
                 ->selectRaw('(SELECT SUBSTRING_INDEX(GROUP_CONCAT(genres.name SEPARATOR ", "), ",", 1)
                  FROM genres JOIN movie_genres ON genres.id = movie_genres.genre_id WHERE movie_genres.movie_id = movies.id) AS genre_name')
                  ->join('movie_genres', 'movies.id', '=', 'movie_genres.movie_id')
                  ->where('movie_genres.genre_id', '=', $genre)
                      ->from('movies')
                      ->where('active', '=', 1)
                      ->orderBy('created_at', 'desc');
                      
                    $query->unionAll(function ($query) use ($genre) {
                        $query->select('series.id', 'name', 'poster_path', 'backdrop_path',
                         'backdrop_path_tv', 'vote_average', 'subtitle', 'overview', 'first_air_date AS release_date', 
                         'pinned', 'series.created_at', 'views', DB::raw("'serie' AS type"))
                         ->selectRaw('(SELECT SUBSTRING_INDEX(GROUP_CONCAT(genres.name SEPARATOR ", "), ",", 1)
                         FROM genres JOIN serie_genres ON genres.id = serie_genres.genre_id WHERE serie_genres.serie_id = series.id) AS genre_name')
                         ->join('serie_genres', 'series.id', '=', 'serie_genres.serie_id')
                         ->where('serie_genres.genre_id', '=', $genre)
                              ->from('series')
                              ->where('active', '=', 1)
                              ->orderBy('created_at', 'desc');
                    });
    
                    $query->unionAll(function ($query) use ($genre) {
                        $query->select('animes.id', 'name', 'poster_path', 'backdrop_path',
                        'backdrop_path_tv', 'vote_average', 'subtitle', 'overview', 'first_air_date AS release_date', 
                        'pinned', 'animes.created_at', 'views', DB::raw("'anime' AS type"))
                        ->selectRaw('(SELECT SUBSTRING_INDEX(GROUP_CONCAT(genres.name SEPARATOR ", "), ",", 1)
                        FROM genres JOIN anime_genres ON genres.id = anime_genres.genre_id WHERE anime_genres.anime_id = animes.id) AS genre_name')
                        ->join('anime_genres', 'animes.id', '=', 'anime_genres.anime_id')
                        ->where('anime_genres.genre_id', '=', $genre)
                              ->from('animes')
                              ->where('active', '=', 1)
                              ->orderBy('created_at', 'desc')
                              ->limit(10);
                    });
            })
            ->orderByDesc('created_at')
            ->get();
    
    

        }else {

            $novelas = DB::table(function ($query) use ($genre) {
                $query->select('movies.id', 'title AS name', 'poster_path', 'backdrop_path', 
                'backdrop_path_tv', 'vote_average', 'subtitle', 'overview', 'release_date', 'pinned',
                 'movies.created_at', 'views', DB::raw("'movie' AS type"))
                 ->selectRaw('(SELECT SUBSTRING_INDEX(GROUP_CONCAT(genres.name SEPARATOR ", "), ",", 1)
                  FROM genres JOIN movie_genres ON genres.id = movie_genres.genre_id WHERE movie_genres.movie_id = movies.id) AS genre_name')
                  ->join('movie_genres', 'movies.id', '=', 'movie_genres.movie_id')
                  ->where('movie_genres.genre_id', '=', $genre)
                      ->from('movies')
                      ->where('active', '=', 1)
                      ->orderBy('created_at', 'desc');
                      
                    $query->unionAll(function ($query) use ($genre) {
                        $query->select('series.id', 'name', 'poster_path', 'backdrop_path',
                         'backdrop_path_tv', 'vote_average', 'subtitle', 'overview', 'first_air_date AS release_date', 
                         'pinned', 'series.created_at', 'views', DB::raw("'serie' AS type"))
                         ->selectRaw('(SELECT SUBSTRING_INDEX(GROUP_CONCAT(genres.name SEPARATOR ", "), ",", 1)
                         FROM genres JOIN serie_genres ON genres.id = serie_genres.genre_id WHERE serie_genres.serie_id = series.id) AS genre_name')
                         ->join('serie_genres', 'series.id', '=', 'serie_genres.serie_id')
                         ->where('serie_genres.genre_id', '=', $genre)
                              ->from('series')
                              ->where('active', '=', 1)
                              ->orderBy('created_at', 'desc');
                    });
            })
            ->orderByDesc('created_at')
            ->get();
        }
        
        
        if($settings->anime){

            $marvel = DB::table(function ($query) use ($genremarvel) {
                $query->select('movies.id', 'title AS name', 'poster_path', 'backdrop_path', 
                'backdrop_path_tv', 'vote_average', 'subtitle', 'overview', 'release_date', 'pinned',
                 'movies.created_at', 'views', DB::raw("'movie' AS type"))
                 ->selectRaw('(SELECT SUBSTRING_INDEX(GROUP_CONCAT(genres.name SEPARATOR ", "), ",", 1)
                  FROM genres JOIN movie_genres ON genres.id = movie_genres.genre_id WHERE movie_genres.movie_id = movies.id) AS genre_name')
                  ->join('movie_genres', 'movies.id', '=', 'movie_genres.movie_id')
                  ->where('movie_genres.genre_id', '=', $genremarvel)
                      ->from('movies')
                      ->where('active', '=', 1)
                      ->inRandomOrder()
                      ->limit(10);
                     
                      
                    $query->unionAll(function ($query) use ($genremarvel) {
                        $query->select('series.id', 'name', 'poster_path', 'backdrop_path',
                         'backdrop_path_tv', 'vote_average', 'subtitle', 'overview', 'first_air_date AS release_date', 
                         'pinned', 'series.created_at', 'views', DB::raw("'serie' AS type"))
                         ->selectRaw('(SELECT SUBSTRING_INDEX(GROUP_CONCAT(genres.name SEPARATOR ", "), ",", 1)
                         FROM genres JOIN serie_genres ON genres.id = serie_genres.genre_id WHERE serie_genres.serie_id = series.id) AS genre_name')
                         ->join('serie_genres', 'series.id', '=', 'serie_genres.serie_id')
                         ->where('serie_genres.genre_id', '=', $genremarvel)
                              ->from('series')
                              ->where('active', '=', 1)
                              ->inRandomOrder()
                              ->limit(10);
                    });
    
                    $query->unionAll(function ($query) use ($genremarvel) {
                        $query->select('animes.id', 'name', 'poster_path', 'backdrop_path',
                        'backdrop_path_tv', 'vote_average', 'subtitle', 'overview', 'first_air_date AS release_date', 
                        'pinned', 'animes.created_at', 'views', DB::raw("'anime' AS type"))
                        ->selectRaw('(SELECT SUBSTRING_INDEX(GROUP_CONCAT(genres.name SEPARATOR ", "), ",", 1)
                        FROM genres JOIN anime_genres ON genres.id = anime_genres.genre_id WHERE anime_genres.anime_id = animes.id) AS genre_name')
                        ->join('anime_genres', 'animes.id', '=', 'anime_genres.anime_id')
                        ->where('anime_genres.genre_id', '=', $genremarvel)
                              ->from('animes')
                              ->where('active', '=', 1)
                              ->inRandomOrder()
                              ->limit(10);
                    });
            })
            ->orderByDesc('created_at')
            ->get();
    
    

        }else {

            $marvel = DB::table(function ($query) use ($genremarvel) {
                $query->select('movies.id', 'title AS name', 'poster_path', 'backdrop_path', 
                'backdrop_path_tv', 'vote_average', 'subtitle', 'overview', 'release_date', 'pinned',
                 'movies.created_at', 'views', DB::raw("'movie' AS type"))
                 ->selectRaw('(SELECT SUBSTRING_INDEX(GROUP_CONCAT(genres.name SEPARATOR ", "), ",", 1)
                  FROM genres JOIN movie_genres ON genres.id = movie_genres.genre_id WHERE movie_genres.movie_id = movies.id) AS genre_name')
                  ->join('movie_genres', 'movies.id', '=', 'movie_genres.movie_id')
                  ->where('movie_genres.genre_id', '=', $genre2)
                      ->from('movies')
                      ->where('active', '=', 1)
                      ->inRandomOrder()
                      ->limit(10);
                      
                    $query->unionAll(function ($query) use ($genremarvel) {
                        $query->select('series.id', 'name', 'poster_path', 'backdrop_path',
                         'backdrop_path_tv', 'vote_average', 'subtitle', 'overview', 'first_air_date AS release_date', 
                         'pinned', 'series.created_at', 'views', DB::raw("'serie' AS type"))
                         ->selectRaw('(SELECT SUBSTRING_INDEX(GROUP_CONCAT(genres.name SEPARATOR ", "), ",", 1)
                         FROM genres JOIN serie_genres ON genres.id = serie_genres.genre_id WHERE serie_genres.serie_id = series.id) AS genre_name')
                         ->join('serie_genres', 'series.id', '=', 'serie_genres.serie_id')
                         ->where('serie_genres.genre_id', '=', $genremarvel)
                              ->from('series')
                              ->where('active', '=', 1)
                              ->inRandomOrder()
                              ->limit(10);
                    });
            })
            ->inRandomOrder()
            ->get();
        }
            
            
            

        if ($settings->anime) {

            $latest = DB::table(function ($query) use ($selectMovie,$selectSerie,$selectAnime,$genresMovies,$genresSeries,$genresAnimes) {
                $query->select(array_merge(
                    $selectMovie,
                    [
                        $genresMovies,
                    ]
                ))
                    ->from('movies')
                    ->where('active', '=', 1)
                    ->orderBy('created_at', 'desc')
                    ->limit(10);

                $query->unionAll(function ($query) use ($selectSerie,$genresSeries) {
                    $query->select(array_merge(
                        $selectSerie,
                        [
                            $genresSeries,
                        ]
                    ))
                        ->from('series')
                        ->where('active', '=', 1)
                        ->orderBy('created_at', 'desc')
                        ->limit(10);
                });

                $query->unionAll(function ($query) use ($selectAnime,$genresAnimes) {
                    $query->select(array_merge(
                        $selectAnime,
                        [
                            $genresAnimes,
                        ]
                    ))
                        ->from('animes')
                        ->where('active', '=', 1)
                        ->orderBy('created_at', 'desc')
                        ->limit(10);
                });
            })
                 ->orderByDesc('created_at')
                ->get();

        } else {

            $latest = DB::table(function ($query) use ($selectMovie,$selectSerie,$selectAnime,$genresMovies,$genresSeries,$genresAnimes) {
                $query->select(array_merge(
                    $selectMovie,
                    [
                        $genresMovies,
                    ]
                ))
                    ->from('movies')
                    ->where('active', '=', 1)
                    ->orderBy('created_at', 'desc')
                    ->limit(10);

                    $query->unionAll(function ($query) use ($selectSerie,$genresSeries) {
                        $query->select(array_merge(
                            $selectSerie,
                            [
                                $genresSeries,
                            ]
                        ))
                        ->from('series')
                        ->where('active', '=', 1)
                        ->orderBy('created_at', 'desc')
                        ->limit(10);
                });
            })
                ->orderByDesc('created_at')
                ->get();
        }

        if($settings->anime){

            $arraythisweek = DB::table(function ($query) use ($selectMovie,$selectSerie,$selectAnime,$genresMovies,$genresSeries,$genresAnimes) {
                $query->select(array_merge(
                    $selectMovie,
                    [
                        $genresMovies,
                    ]
                ))
                      ->from('movies')
                      ->where('active', '=', 1)
                      ->orderBy('created_at', 'desc')
                      ->limit(10);
            
                      $query->unionAll(function ($query) use ($selectSerie,$genresSeries) {
                        $query->select(array_merge(
                            $selectSerie,
                            [
                                $genresSeries,
                            ]
                        ))
                          ->from('series')
                          ->where('active', '=', 1)
                          ->orderBy('created_at', 'desc')
                          ->limit(10);
                });
            
                $query->unionAll(function ($query) use ($selectAnime,$genresAnimes) {
                    $query->select(array_merge(
                        $selectAnime,
                        [
                            $genresAnimes,
                        ]
                    ))
                          ->from('animes')
                          ->where('active', '=', 1)
                          ->orderBy('created_at', 'desc')
                          ->limit(10);
                });
            })
            ->orderByDesc('created_at')
            ->where('created_at', '>', Carbon::now()->startOfWeek())
            ->get();
            
                


        }else {

            $arraythisweek = DB::table(function ($query) use ($selectMovie,$selectSerie,$selectAnime,$genresMovies,$genresSeries,$genresAnimes) {
                $query->select(array_merge(
                    $selectMovie,
                    [
                        $genresMovies,
                    ]
                ))
                      ->from('movies')
                      ->where('active', '=', 1)
                      ->orderBy('created_at', 'desc')
                      ->limit(10);
            
                      $query->unionAll(function ($query) use ($selectSerie,$genresSeries) {
                        $query->select(array_merge(
                            $selectSerie,
                            [
                                $genresSeries,
                            ]
                        ))
                          ->from('series')
                          ->where('active', '=', 1)
                          ->orderBy('created_at', 'desc')
                          ->limit(10);
                });
            })
            ->orderByDesc('created_at')
            ->where('created_at', '>', Carbon::now()->startOfWeek())
            ->get();
            
                

        }
       


        if($settings->anime){

            $arraychoosed = DB::table(function ($query) use ($selectMovie,$selectSerie,$selectAnime,$genresMovies,$genresSeries,$genresAnimes) {
                $query->select(array_merge(
                    $selectMovie,
                    [
                        $genresMovies,
                    ]
                ))
                      ->from('movies')
                      ->where('active', '=', 1)
                      ->limit(10);
            
                      $query->unionAll(function ($query) use ($selectSerie,$genresSeries) {
                        $query->select(array_merge(
                            $selectSerie,
                            [
                                $genresSeries,
                            ]
                        ))
                          ->from('series')
                          ->where('active', '=', 1)
                          ->limit(10);
                });
            
                $query->unionAll(function ($query) use ($selectAnime,$genresAnimes) {
                    $query->select(array_merge(
                        $selectAnime,
                        [
                            $genresAnimes,
                        ]
                    ))
                          ->from('animes')
                          ->where('active', '=', 1)
                          ->limit(10);
                });
            })
            ->inRandomOrder()
            ->get();
            

        }else {


            $arraychoosed = DB::table(function ($query) use ($selectMovie,$selectSerie,$selectAnime,$genresMovies,$genresSeries,$genresAnimes) {
                $query->select(array_merge(
                    $selectMovie,
                    [
                        $genresMovies,
                    ]
                ))
                      ->from('movies')
                      ->where('active', '=', 1)
                      ->limit(10);
            
                      $query->unionAll(function ($query) use ($selectSerie,$genresSeries) {
                        $query->select(array_merge(
                            $selectSerie,
                            [
                                $genresSeries,
                            ]
                        ))
                          ->from('series')
                          ->where('active', '=', 1)
                          ->limit(10);
                });
            })
            ->inRandomOrder()
            ->get();
            
        }
        


        if($settings->anime){


            $arraytrending = DB::table(function ($query) use ($selectMovie,$selectSerie,$selectAnime,$genresMovies,$genresSeries,$genresAnimes) {
                $query->select(array_merge(
                    $selectMovie,
                    [
                        $genresMovies,
                    ]
                ))
                      ->from('movies')
                      ->where('active', '=', 1)
                      ->limit(10);
            
                      $query->unionAll(function ($query) use ($selectSerie,$genresSeries) {
                        $query->select(array_merge(
                            $selectSerie,
                            [
                                $genresSeries,
                            ]
                        ))
                          ->from('series')
                          ->where('active', '=', 1)
                          ->limit(10);
                });
            
                $query->unionAll(function ($query) use ($selectAnime,$genresAnimes) {
                    $query->select(array_merge(
                        $selectAnime,
                        [
                            $genresAnimes,
                        ]
                    ))
                          ->from('animes')
                          ->where('active', '=', 1)
                          ->limit(10);
                });
            })
            ->where('views', '>', 10)
            ->orderByDesc('views')
            ->get();

        }else {

            $arraytrending = DB::table(function ($query) use ($selectMovie,$selectSerie,$selectAnime,$genresMovies,$genresSeries,$genresAnimes) {
                $query->select(array_merge(
                    $selectMovie,
                    [
                        $genresMovies,
                    ]
                ))
                      ->from('movies')
                      ->where('active', '=', 1)
                      ->limit(10);
            
                      $query->unionAll(function ($query) use ($selectSerie,$genresSeries) {
                        $query->select(array_merge(
                            $selectSerie,
                            [
                                $genresSeries,
                            ]
                        ))
                          ->from('series')
                          ->where('active', '=', 1)
                          ->limit(10);
                });
            })
            ->where('views', '>', 10)
            ->orderByDesc('views')
            ->get();

        }
       



        if($settings->anime){

        $arrayrecommended = DB::table(function ($query) use ($selectMovie,$selectSerie,$selectAnime,$genresMovies,$genresSeries,$genresAnimes) {
            $query->select(array_merge(
                $selectMovie,
                [
                    $genresMovies,
                ]
            ))
                  ->from('movies')
                  ->where('active', '=', 1)
                  ->limit(10);
        
                  $query->unionAll(function ($query) use ($selectSerie,$genresSeries) {
                    $query->select(array_merge(
                        $selectSerie,
                        [
                            $genresSeries,
                        ]
                    ))
                      ->from('series')
                      ->where('active', '=', 1)
                      ->limit(10);
            });
        
            $query->unionAll(function ($query) use ($selectAnime,$genresAnimes) {
                $query->select(array_merge(
                    $selectAnime,
                    [
                        $genresAnimes,
                    ]
                ))
                      ->from('animes')
                      ->where('active', '=', 1)
                      ->limit(10);
            });
        })
        ->where('vote_average', '>', 7.0)
        ->inRandomOrder()
        ->get();

        }else {



            $arrayrecommended = DB::table(function ($query) use ($selectMovie,$selectSerie,$selectAnime,$genresMovies,$genresSeries,$genresAnimes) {
                $query->select(array_merge(
                    $selectMovie,
                    [
                        $genresMovies,
                    ]
                ))
                      ->from('movies')
                      ->where('active', '=', 1)
                      ->limit(10);
            
                      $query->unionAll(function ($query) use ($selectSerie,$genresSeries) {
                        $query->select(array_merge(
                            $selectSerie,
                            [
                                $genresSeries,
                            ]
                        ))
                          ->from('series')
                          ->where('active', '=', 1)
                          ->limit(10);
                });
            })
            ->where('vote_average', '>', 7.0)
            ->inRandomOrder()
            ->get();

        }



        


        if($settings->anime){

            $arraypinned = DB::table(function ($query) use ($selectMovie,$selectSerie,$selectAnime,$genresMovies,$genresSeries,$genresAnimes) {
                $query->select(array_merge(
                    $selectMovie,
                    [
                        $genresMovies,
                    ]
                ))
                      ->from('movies')
                      ->where('active', '=', 1);
            
                      $query->unionAll(function ($query) use ($selectSerie,$genresSeries) {
                        $query->select(array_merge(
                            $selectSerie,
                            [
                                $genresSeries,
                            ]
                        ))
                          ->from('series')
                          ->where('active', '=', 1);
                });
            
                $query->unionAll(function ($query) use ($selectAnime,$genresAnimes) {
                    $query->select(array_merge(
                        $selectAnime,
                        [
                            $genresAnimes,
                        ]
                    ))
                          ->from('animes')
                          ->where('active', '=', 1);
                });
            })
            ->where('pinned', 1)
            ->orderByDesc('updated_at')
            ->get();

        }else {


            $arraypinned = DB::table(function ($query) use ($selectMovie,$selectSerie,$selectAnime,$genresMovies,$genresSeries,$genresAnimes) {
                $query->select(array_merge(
                    $selectMovie,
                    [
                        $genresMovies,
                    ]
                ))
                      ->from('movies')
                      ->where('active', '=', 1);
            
                      $query->unionAll(function ($query) use ($selectSerie,$genresSeries) {
                        $query->select(array_merge(
                            $selectSerie,
                            [
                                $genresSeries,
                            ]
                        ))
                          ->from('series')
                          ->where('active', '=', 1);
                });
            })
            ->where('pinned', 1)
            ->orderByDesc('created_at')
            ->get();

        }
        
        if($settings->anime){

            $arraytop10series = DB::table(function ($query) use ($selectMovie,$selectSerie,$genresMovies,$genresSeries) {
                $query->select(array_merge(
                    $selectMovie,
                    [
                        $genresMovies,
                    ]
                ))
                      ->from('movies')
                      ->where('active', '=', 1)
                      ->orderBy('views', 'desc')
                      ->limit(0);
            
                      $query->unionAll(function ($query) use ($selectSerie,$genresSeries) {
                        $query->select(array_merge(
                            $selectSerie,
                            [
                                $genresSeries,
                            ]
                        ))
                          ->from('series')
                          ->where('active', '=', 1)
                          ->orderBy('views', 'desc')
                          ->limit(10);
                });
            
            })
            ->orderBy('views', 'desc')
            ->get();

        }else {


            $arraytop10series = DB::table(function ($query) use ($selectMovie,$selectSerie,$selectAnime,$genresMovies,$genresSeries,$genresAnimes) {
                $query->select(array_merge(
                    $selectMovie,
                    [
                        $genresMovies,
                    ]
                ))
                      ->from('movies')
                      ->where('active', '=', 1)
                      ->orderBy('views', 'desc')
                      ->limit(0);
            
                      $query->unionAll(function ($query) use ($selectSerie,$genresSeries) {
                        $query->select(array_merge(
                            $selectSerie,
                            [
                                $genresSeries,
                            ]
                        ))
                          ->from('series')
                          ->where('active', '=', 1)
                          ->orderBy('views', 'desc')
                          ->limit(10);
                });
            })
            ->orderBy('views', 'desc')
            ->get();
        }

           


        if($settings->anime){

            $arraytop10 = DB::table(function ($query) use ($selectMovie,$selectSerie,$genresMovies,$genresSeries) {
                $query->select(array_merge(
                    $selectMovie,
                    [
                        $genresMovies,
                    ]
                ))
                      ->from('movies')
                      ->where('active', '=', 1)
                      ->orderBy('views', 'desc')
                      ->limit(10);
            
                      $query->unionAll(function ($query) use ($selectSerie,$genresSeries) {
                        $query->select(array_merge(
                            $selectSerie,
                            [
                                $genresSeries,
                            ]
                        ))
                          ->from('series')
                          ->where('active', '=', 1)
                          ->orderBy('views', 'desc')
                          ->limit(0);
                });
            
            })
            ->orderBy('views', 'desc')
            ->get();

        }else {


            $arraytop10 = DB::table(function ($query) use ($selectMovie,$selectSerie,$selectAnime,$genresMovies,$genresSeries,$genresAnimes) {
                $query->select(array_merge(
                    $selectMovie,
                    [
                        $genresMovies,
                    ]
                ))
                      ->from('movies')
                      ->where('active', '=', 1)
                      ->orderBy('views', 'desc')
                      ->limit(10);
            
                      $query->unionAll(function ($query) use ($selectSerie,$genresSeries) {
                        $query->select(array_merge(
                            $selectSerie,
                            [
                                $genresSeries,
                            ]
                        ))
                          ->from('series')
                          ->where('active', '=', 1)
                          ->orderBy('views', 'desc')
                          ->limit(0);
                });
            })
            ->orderBy('views', 'desc')
            ->get();
        }
   


        if($settings->anime){

        $animeslatest = DB::table(function ($query) use ($selectAnime,$genresAnimes) {
            $query->select(array_merge(
                $selectAnime,
                [
                    $genresAnimes,
                ]
            ))
                  ->from('animes')
                  ->where('active', '=', 1)
                  ->orderBy('created_at', 'desc')
                  ->limit(10);
        })
        ->orderBy('created_at', 'desc')
        ->get();
    }


        $popularSeries = DB::table(function ($query) use ($selectSerie,$genresSeries) {
            $query->select(array_merge(
                $selectSerie,
                [
                    $genresSeries,
                ]
            ))
                  ->from('series')
                  ->where('active', '=', 1)
                  ->orderBy('created_at', 'desc')
                  ->limit(10);
        })
        ->where('views', '>', 500)
        ->orderByDesc('views')
        ->get();

        

        $recentSeries = DB::table(function ($query) use ($selectSerie,$genresSeries) {
            $query->select(array_merge(
                $selectSerie,
                [
                    $genresSeries,
                ]
            ))
                  ->from('series')
                  ->where('active', '=', 1)
                  ->orderBy('created_at', 'desc')
                  ->limit(10);
        })
        ->orderBy('created_at', 'desc')
        ->get();
             

            $featured = Featured::query()->orderBy('position')->orderByDesc('updated_at')
            ->limit($settings->featured_home_numbers)
             ->get();


                $newEpisodes2 = DB::table('series')
                ->select(
                       
                    array_merge(
                        $selectSerieEpisodes,
                        [
                            $genresSeries,
                        ]
                    ))
                    ->join('seasons', 'seasons.serie_id', '=', 'series.id')
                    ->join('episodes', 'episodes.season_id', '=', 'seasons.id')
                    ->join('serie_videos', function ($join) {
                        $join->on('serie_videos.episode_id', '=', 'episodes.id')
                            ->orderBy('serie_videos.updated_at', 'desc');
                    })
                    ->where('series.active', '=', 1)
                    ->limit(10)
                    ->orderBy('serie_videos.updated_at', 'desc')
                    ->groupBy('episodes.id')
                    ->get();



                if($settings->anime){


                    $latestEpisodesAnimes = DB::table('animes')
                    ->select(
                       
                    array_merge(
                        $selectAnimeEpisodes,
                        [
                            $genresAnimes,
                        ]
                    ))
                    ->join('anime_seasons', 'anime_seasons.anime_id', '=', 'animes.id')
                    ->join('anime_episodes', 'anime_episodes.anime_season_id', '=', 'anime_seasons.id')
                    ->join('anime_videos', function ($join) {
                        $join->on('anime_videos.anime_episode_id', '=', 'anime_episodes.id')
                            ->orderBy('anime_videos.updated_at', 'desc');
                    })
                    ->where('animes.active', '=', 1)
                    ->limit(10)
                    ->orderBy('anime_videos.updated_at', 'desc')
                    ->groupBy('anime_episode_id')
                    ->get();

                 }




                        //ray()->showQueries1();
                        ray()->measure();

                        // dd ($arraytop10);

                        // return response()->json($arraytop10);


                        return view('layouts.pages.inicio',[
                            'novelas' => $novelas,
                            'marvel' => $marvel,
                            'gratis' => $gratis,
                            'latest' => $latest,
                            'latest_episodes' => $newEpisodes2,
                            'latest_episodes_animes' => $latestEpisodesAnimes,
                            'thisweek' => $arraythisweek,
                            'choosed' => $arraychoosed,
                            'recommended' => $arrayrecommended,
                            'trending' => $arraytrending,
                            'pinned' => $arraypinned,
                            'top10' => $arraytop10,
                            'top10series' => $arraytop10series,
                            'featured' => $featured,
                            'anime' => $animeslatest,
                            'popularSeries' => $popularSeries,
                            'recents' => $recentSeries]);




            }

            public function homeitens()
            {    
                $genresMovies = DB::raw('(SELECT SUBSTRING_INDEX(GROUP_CONCAT(genres.name SEPARATOR ", "), ",", 1)
                            FROM genres JOIN movie_genres ON genres.id = movie_genres.genre_id WHERE movie_genres.movie_id = movies.id)
                            AS genre_name');

                $selectMovie = [
                    'id', 'title AS name', 'poster_path', 'backdrop_path',
                    'backdrop_path_tv', 'vote_average', 'subtitle', 'overview', 'release_date', 'pinned',
                    'created_at','updated_at', 'views', DB::raw("'movie' AS type")
                ];

                $arraytop10 = DB::table(function ($query) use ($selectMovie, $genresMovies) {
                    $query->select(array_merge(
                        $selectMovie,
                        [
                            $genresMovies,
                        ]
                    ))
                    ->from('movies')
                    ->where('active', '=', 1)
                    ->orderBy('views', 'desc')
                    ->limit(10);
                })
                ->orderBy('views', 'desc')
                ->get();   
                
                // dd($arraytop10);
                
                return view('layouts._partials.homeitens', ['top10' => $arraytop10]);
            }
}
