<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Subscription;

class AtivarController extends Controller
{
    public function verificarEmail(Request $request)
    {
        // Validar os dados recebidos do formulário
        $request->validate([
            'email' => 'required|email',
        ]);

        // Verificar se o email existe no banco de dados
        $user = Users::where('email', $request->email)->first();

        if (!$user) {
            return redirect()->back()->withErrors('Email não encontrado.');
        }

        // Verificar se o pagamento foi aprovado
        if (!$request->payment_approved) {
            return redirect()->back()->withErrors('Pagamento não aprovado.');
        }

        // Verificar se o usuário já possui uma assinatura ativa
        if ($user->hasActiveSubscription()) {
            return redirect()->route('sucesso')->with('success', 'Usuário já possui uma assinatura ativa.');
        }

        // Ativar a assinatura para o usuário encontrado
        $subscription = new Subscription();
        $subscription->user_id = $user->id;
        $subscription->status = 'ativo'; // ou qualquer outro valor que você utilize para indicar o status ativo
        $subscription->save();

        // Redirecionar para uma página de sucesso
        return redirect()->route('sucesso')->with('success', 'Assinatura ativada com sucesso!');
    }
}
