<?php

namespace App\Http\Controllers\Api\Auth;

use App\Http\Controllers\Controller;
use App\User;
use Illuminate\Http\Request;
use Laravel\Passport\Client;
use Illuminate\Support\Carbon;

class RegisterController extends Controller
{
    use IssueTokenTrait;

    private $client;

    public function __construct()
    {
       $this->client = Client::find(2);
        $this->middleware('doNotCacheResponse');

    }

    public function register(Request $request)
{
    $this->validate($request, [
        'name' => 'required',
        'email' => 'required|email|unique:users,email',
        'password' => [
            'required',
            'string',
            'min:6', 
        ]
    ]);

    $user = User::create([
        'name' => $request->name,
        'email' => $request->email,
        'avatar' => $request->root() . '/api/avatars/image/avatar_default.png',
        'premuim' => true,
        'manual_premuim' => false,
        'expired_in'=> Carbon::now()->addMinutes(1),
        'password' => bcrypt($request->password)
    ]);

    // Emita o token
    $result = $this->issueToken($request, 'password'); // Presumindo que isso retorna uma resposta com o token

    // Adicione o ID do usuário à resposta do token
    $response = json_decode($result->getContent(), true); // Converte a resposta para array
    $response['user_id'] = $user->id; // Adiciona o ID do usuário

    return response()->json($response); // Retorna a resposta modificada
}


}
