<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Elastic\Adapter\Exceptions\BulkOperationException;

class DebugScoutImport extends Command
{
    protected $signature = 'debug:scout-import';
    protected $description = 'Debug the Scout import for movies';

    public function handle()
    {
        try {
            $this->call('scout:import', ['model' => 'App\Movie']);
        } catch (BulkOperationException $e) {
            $this->line('Elasticsearch Bulk Error Details:');
            dd($e->rawResult());
        }
    }
}
