<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class VideoAccessToken extends Model
{
    // Use HasFactory se você estiver usando Laravel 8 ou superior


    // Defina a tabela, se não seguir a convenção padrão do Laravel
    protected $table = 'video_access_tokens';

    // Defina os atributos que podem ser atribuídos em massa
    protected $fillable = [
        'livetv_video_id', 'user_id', 'token', 'expires_at'
    ];

    // Casts para campos que devem ser automaticamente convertidos para tipos específicos
    protected $casts = [
        'expires_at' => 'datetime',
    ];

    /**
     * Relacionamento com o modelo User.
     */
    public function user()
    {
        return $this->belongsTo('App\User');
    }

    /**
     * Relacionamento com o modelo LivetvVideo.
     */
    public function livetvVideo()
    {
        return $this->belongsTo('App\LivetvVideo');
    }
}
