<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class UsuarioSorteio extends Model
{
    protected $table = 'usuarios_sorteio';
    protected $fillable = ['email', 'nome', 'chave_pix', 'sorteado'];
    
    public function sorteiosGanhos()
    {
    return $this->belongsToMany(Sorteio::class, 'sorteio_vencedores', 'usuario_id', 'sorteio_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'email', 'email');
    }
    
}