<?php

namespace App;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Laravel\Fortify\TwoFactorAuthenticatable;
use Laravel\Cashier\Billable;
use App\Notifications\PasswordReset;
use Laravel\Passport\HasApiTokens;
use BeyondCode\Comments\Contracts\Commentator;
use ChristianKuri\LaravelFavorite\Traits\Favoriteability;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use App\SupportTicket;



class User extends Authenticatable implements Commentator
{
    use Notifiable, HasApiTokens,Billable,HasFactory,Favoriteability;

    const MAX_ACTIVE_SESSIONS = 1;

    protected $with = ['profiles'];


    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name','tv_access','expired_in_tv', 'email', 'password', 'whatsapp','avatar', 'premuim','transaction_id ','manual_premuim','pack_name','pack_id','start_at','expired_in','role','email_verified_at'
        ,'type', 'provider_name', 'provider_id','phone'];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];


    protected $casts = [
        'premuim' => 'int',
        'tv_access' => 'int'

    ];


    protected $appends = ['favoritesMovies','favoritesSeries','favoritesAnimes','favoritesStreaming'];


    protected $dates = [
        'email_verified_at' => 'datetime', 'trial_ends_at', 'subscription_ends_at', 'expired_in'
    ];

    /**
     * Verifica se o usuário é premium e sua assinatura está ativa
     *
     * @return bool
     */
    public function isPremiumActive()
    {
        return $this->premuim == 1 &&
               ($this->expired_in === null || $this->expired_in->greaterThanOrEqualTo(now()));
    }

    public function findFacebookUserForPassport($token) {
        // Your logic here using Socialite to push user data from Facebook generated token.
    }


    public function sendPasswordResetNotification($token)
{
    $this->notify(new PasswordReset($token));
}



    public function needsCommentApproval($model): bool
    {
        return false;
    }



    public function profiles()
{
    return $this->hasMany(Profile::class, 'user_id');
}

    /**
     * Relacionamento com a assinatura atual do usuário
     */
    public function subscription()
    {
        return $this->hasOne(\App\Subscription::class)->latest();
    }

    /**
     * Relacionamento com todas as assinaturas do usuário
     */
    public function subscriptions()
    {
        return $this->hasMany(\App\Subscription::class);
    }

    /**
     * Relacionamento com os dispositivos do usuário
     */
    public function devices()
    {
        return $this->hasMany(\App\Device::class);
    }

    /**
     * Retorna os tickets de suporte do usuário
     */
    public function supportTickets()
    {
        return $this->hasMany(\App\Models\SupportTicket::class);
    }


    public function getFavoritesMoviesAttribute()
    {


        $settings = Setting::query()->first();

        $newEpisodes = [];

        if ($settings->favoriteonline) {


            $movies = $this->favorite(Movie::class);

            $subset = $movies->map(function ($user) {
                return collect($user->toArray())
                    ->only(['id', 'title', 'poster_path'])
                    ->all();
            });



            foreach ($subset as $item) {
                array_push($newEpisodes, $item);
            }

        }

        return $newEpisodes;


    }


    public function getFavoritesSeriesAttribute()
    {


        $settings = Setting::query()->first();

        $newEpisodes = [];

        if ($settings->favoriteonline) {

            $movies = $this->favorite(Serie::class);

            $subset = $movies->map(function ($user) {
                return collect($user->toArray())
                ->only(['id', 'name', 'poster_path'])
                    ->all();
            });


            foreach ($subset as $item) {
                array_push($newEpisodes, $item);
            }


        }


        return $newEpisodes;
    }



    public function getFavoritesAnimesAttribute()
    {


        $settings = Setting::query()->first();

        $newEpisodes = [];

        if ($settings->favoriteonline) {

            $movies = $this->favorite(Anime::class);

            $subset = $movies->map(function ($user) {
                return collect($user->toArray())
                ->only(['id', 'name', 'poster_path'])
                    ->except(['seasons', 'casterslist', 'casters', 'networkslist', 'networks.network'])
                    ->all();
            });


            foreach ($subset as $item) {
                array_push($newEpisodes, $item);
            }


        }


        return $newEpisodes;
    }

    public function isLoggedOut($deviceToken)
    {
        return $this->device_token !== $deviceToken;
    }


    public function getFavoritesStreamingAttribute()
    {

        $settings = Setting::query()->first();

        $newEpisodes = [];

        if ($settings->favoriteonline) {

            $livetv = $this->favorite(Livetv::class);

            $subset = $livetv->map(function ($user) {
                return collect($user->toArray())
                ->only(['id', 'name', 'poster_path'])
                    ->all();
            });


            foreach ($subset as $item) {
                array_push($newEpisodes, $item);
            }


        }


        return $newEpisodes;
    }




}
