<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SupportTicket extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'subject',
        'message',
        'category',
        'status',
        'admin_response',
        'admin_id'
    ];

    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function admin()
    {
        return $this->belongsTo(User::class, 'admin_id');
    }

    public static function getCategories()
    {
        return [
            'problema_tecnico' => 'Problema Técnico',
            'cobranca' => 'Cobrança e Pagamento',
            'conteudo' => 'Problema com Conteúdo',
            'conta' => 'Conta de Usuário',
            'outros' => 'Outros'
        ];
    }
}
