<?php

namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class Sorteio extends Model
{
    
    protected $table = 'sorteios';
    /**
     * Os atributos que são mass assignable.
     *
     * @var array
     */
    protected $fillable = ['titulo', 'descricao', 'imagem', 'data_sorteio'];


    /**
     * Atributos que devem ser mutados para dates.
     *
     * @var array
     */
    protected $dates = [
        'data_sorteio',
    ];
    
    
    public function vencedores() {
        return $this->belongsToMany(UsuarioSorteio::class, 'sorteio_vencedores', 'sorteio_id', 'usuario_id');
    }

    
}