<?php 

// app/Services/BackblazeService.php

namespace App\Services;

use GuzzleHttp\Client;

class BackblazeService
{
    protected $accountId;
    protected $applicationKey;
    protected $bucketName;
    protected $client;

    public function __construct()
    {
        $this->accountId = env('BACKBLAZE_ACCOUNT_ID');
        $this->applicationKey = env('BACKBLAZE_APPLICATION_KEY');
        $this->bucketName = env('BACKBLAZE_BUCKET_NAME');
        $this->client = new Client();
    }

    public function authorizeAccount()
    {
        $response = $this->client->request('GET', 'https://api.backblazeb2.com/b2api/v2/b2_authorize_account', [
            'auth' => [$this->accountId, $this->applicationKey],
        ]);

        return json_decode($response->getBody()->getContents(), true);
    }

    public function listFiles()
{
    $authorization = $this->authorizeAccount();
    $response = $this->client->request('POST', $authorization['apiUrl'] . '/b2api/v2/b2_list_file_names', [
        'headers' => [
            'Authorization' => $authorization['authorizationToken'],
        ],
        'json' => [
            'bucketId' => env('BACKBLAZE_BUCKET_ID'),
            
        ],
    ]);

    return json_decode($response->getBody()->getContents(), true);
}
}
