<?php

namespace App\Providers;

use Illuminate\Database\Schema\Builder;
use Illuminate\Support\ServiceProvider;
use Illuminate\Database\Eloquent\Model;
use Laravel\Passport\Passport;
use Laravel\Passport\Bridge\RefreshTokenRepository;
use League\OAuth2\Server\AuthorizationServer;
use App\Grants\FacebookGrant;
use App\Grants\FacebookUserRepository;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Blade;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\URL;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Builder::defaultStringLength(191); // Update defaultStringLength
        //Model::preventLazyLoading();
        //\Illuminate\Support\Facades\URL::forceScheme('https');
        error_reporting(0);

        Blade::component('layouts._partials.pagination', 'pagination');

        app(AuthorizationServer::class)->enableGrantType(
            $this->makeFacebookGrant(), Passport::tokensExpireIn()
        );

        // Registrar componentes
        Blade::component('cast-list', \App\View\Components\CastList::class);
        Blade::component('episode-list', \App\View\Components\EpisodeList::class);

        // Certifique-se de que esta linha está correta
        $this->app->singleton(\App\Http\Controllers\SuitPayController::class, function ($app) {
            return new \App\Http\Controllers\SuitPayController();
        });

        // Compartilhar URL base com todas as views
        View::share('base_url', URL::to('/'));

        // Forçar HTTPS em produção
        if(config('app.env') === 'production') {
            URL::forceScheme('https');
        }

        // Compartilhar qual gateway de pagamento está ativo com todas as views
        // Usando filter_var para garantir que o valor seja um booleano
        $isPaggueEnabled = filter_var(env('ENABLE_PAGGUE', 'false'), FILTER_VALIDATE_BOOLEAN);
        View::share('payment_gateway', $isPaggueEnabled ? 'paggue' : 'suitpay');
        View::share('is_paggue_enabled', $isPaggueEnabled);

        // Registrar a variável no log para debug
        \Log::info('AppServiceProvider: Gateway ativo', [
            'payment_gateway' => $isPaggueEnabled ? 'paggue' : 'suitpay',
            'ENABLE_PAGGUE (raw)' => env('ENABLE_PAGGUE'),
            'isPaggueEnabled (bool)' => $isPaggueEnabled
        ]);
    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
       //
    }

    protected function makeFacebookGrant()
    {
        $grant = new FacebookGrant(
            $this->app->make(FacebookUserRepository::class),
            $this->app->make(RefreshTokenRepository::class)
        );

        $grant->setRefreshTokenTTL(Passport::refreshTokensExpireIn());

        return $grant;
    }
}
