<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Profile extends Model
{
    protected $fillable = [
        'name', 'avatar', 'user_id'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Acessor para obter a URL completa do avatar
     */
    public function getAvatarUrlAttribute()
    {
        if (!$this->avatar) {
            return asset('/avatars/avatar_default.png');
        }

        // Verifica se o avatar já é uma URL completa
        if (filter_var($this->avatar, FILTER_VALIDATE_URL)) {
            return $this->avatar;
        }

        // Caso contrário, concatena com a URL base
        return asset($this->avatar);
    }

    /**
     * Relação com filmes favoritos
     */
    public function favoriteMovies()
    {
        return $this->belongsToMany(Movie::class, 'profile_movie_favorites', 'profile_id', 'movie_id')
                    ->withTimestamps();
    }

    /**
     * Relação com séries favoritas
     */
    public function favoriteSeries()
    {
        return $this->belongsToMany(Serie::class, 'profile_serie_favorites', 'profile_id', 'serie_id')
                    ->withTimestamps();
    }

    /**
     * Relação com animes favoritos
     */
    public function favoriteAnimes()
    {
        return $this->belongsToMany(Anime::class, 'profile_anime_favorites', 'profile_id', 'anime_id')
                    ->withTimestamps();
    }
}
