<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use App\Setting;

class  PasswordReset extends Notification
{
    use Queueable;



    public $token;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct($token)
{
    $this->token = $token;

    
}

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
{
    $url = url(route('password.reset', $this->token, false));

    return (new MailMessage)
        ->subject('Redefinição de Senha')
        ->line('Você está recebendo este e-mail porque recebemos uma solicitação de redefinição de senha para sua conta.')
        ->action('Redefinir Senha', $url)
        ->line('Se você não solicitou uma redefinição de senha, nenhuma ação adicional é necessária.');
}

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }
}
