<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class MovieCast extends Model
{
    protected $fillable = ['movie_id', 'cast_id']; // Adicione 'movie_id' à matriz fillable

    protected $appends = ['name'];
    protected $hidden = ['cast'];

    public function cast()
    {
        return $this->belongsTo('App\Cast', 'cast_id');
    }

    public function movie()
    {
        return $this->belongsTo('App\Movie', 'movie_id');
    }

    public function getNameAttribute()
    {
        return $this->cast->name;
    }

    public function getProfilePathAttribute()
    {
        return $this->cast->profile_path;
    }
}
