<?php

namespace App\Listeners;

use Illuminate\Auth\Events\Login;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use App\Http\Controllers\DeviceController;
use Illuminate\Support\Facades\Log;

class RegisterUserDevice
{
    /**
     * Handle the event.
     *
     * @param  Login  $event
     * @return void
     */
    public function handle(Login $event)
    {
        try {
            $request = request();
            $user = $event->user;

            // Registrar dispositivo no login
            $device = DeviceController::registerDevice($request);

            if ($device) {
                Log::info('Dispositivo registrado pelo evento de login', [
                    'user_id' => $user->id,
                    'device_id' => $device->id,
                    'device_type' => $device->device_type ?? 'desconhecido'
                ]);
            } else {
                Log::warning('Falha ao registrar dispositivo pelo evento de login', [
                    'user_id' => $user->id
                ]);
            }
        } catch (\Exception $e) {
            Log::error('Erro ao processar evento de login para registro de dispositivo', [
                'error' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ]);
        }
    }
}
