<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use App\Movie;
use App\MovieVideo;

class ProcessarLinkJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $movieName;
    protected $movieLink;

    public function __construct($movieName, $movieLink)
    {
        $this->movieName = $movieName;
        $this->movieLink = $movieLink;
    }

    public function handle()
    {
        // Extrair o nome até o hífen ou remover a extensão do nome e os ":" do nome
        $extension = pathinfo($this->movieLink, PATHINFO_EXTENSION);
        if ($extension === 'avi' || $extension === 'ext') {
            $movieName = trim(explode('-', $this->movieName)[0]);
        } else {
            $movieName = trim(str_replace(':', '', $this->movieName));
        }

        $similarMovie = Movie::where('title', '=', $movieName)->first();

        if ($similarMovie) {
            // Remover todos os vídeos existentes para o filme
            $similarMovie->videos()->delete();

            $movieVideo = new MovieVideo([
                'link' => $this->movieLink,
            ]);

            $similarMovie->videos()->save($movieVideo);
        }
    }
}
