<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;
use App\User;
use App\UsuarioSorteio;

class DeleteNonPremiumUsers implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        Log::info('DeleteNonPremiumUsers Job Started');
    
        $usuariosParaExcluir = UsuarioSorteio::whereHas('user', function ($query) {
            $query->where('premuim', '!=', 1);
        })->get();
    
        Log::info('Users to delete: ' . $usuariosParaExcluir->count());
    
        foreach ($usuariosParaExcluir as $usuario) {
            $usuario->delete();
        }
    
        Log::info('DeleteNonPremiumUsers Job Finished');
    }
}
