<?php 

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class VerifySession
{
    public function handle($request, Closure $next)
    {
        $user = Auth::user();
        if ($user) {
            $currentSession = DB::table('sessions')
                ->where('user_id', $user->id)
                ->where('session_id', $request->session()->getId())
                ->first();

            // Se a sessão atual não for encontrada, deslogue o usuário
            if (!$currentSession) {
                Auth::logout();
                return redirect('login')->withErrors(['Sua sessão foi encerrada em outro dispositivo.']);
            }
        }

        return $next($request);
    }
}
