<?php

namespace App\Http\Middleware;

use Closure;
use Exception;
use Firebase\JWT\JWT;
use Firebase\JWT\Key;
use Firebase\JWT\ExpiredException;
use Firebase\JWT\SignatureInvalidException;
use Firebase\JWT\BeforeValidException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;

class StreamAuthMiddleware
{

    public function handle(Request $request, Closure $next)
    {
        // Substitua "yourwebsite.com" pelo seu domínio
        $allowedOrigin = 'https://site.ultraflix.net/';

        $origin = $request->headers->get('origin');
        $referer = $request->headers->get('referer');

        // Verifica se a origem ou o referer correspondem ao seu domínio
        if ($origin === $allowedOrigin || strpos($referer, $allowedOrigin) === 0) {
            return $next($request);
        }

        // Se a origem não for permitida, retorna um erro 403
        return response()->json(['message' => 'Acesso não autorizado.'], 403);
    }
}