<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class SorteioAdminMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle($request, Closure $next)
{
    if (!Auth::check() || Auth::user()->role !== 'admin') {
        return redirect()->route('sorteioadmin.showLoginForm')->with('error', 'Acesso restrito a administradores.');
    }

    return $next($request);
}
}
