<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;

class RequireAuthForPlayback
{
    /**
     * Handle an incoming request.
     * Verifica se o usuário está autenticado para reprodução de vídeo.
     * Se não estiver, redireciona para a página de login.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        // Se o usuário não está autenticado
        if (!Auth::check()) {
            // Se for uma solicitação AJAX, retorna uma resposta JSON
            if ($request->ajax() || $request->wantsJson()) {
                return response()->json([
                    'error' => 'Unauthorized',
                    'message' => 'Você precisa estar logado para acessar este conteúdo.',
                    'redirect' => route('login')
                ], 401);
            }

            // Se for uma solicitação normal, redireciona para o login
            // Salva a URL atual na sessão para retornar após o login
            return redirect()->route('login')->with('message', 'Você precisa estar logado para assistir aos vídeos.');
        }

        return $next($request);
    }
}
