<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Laravel\Passport\Token;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class MultiDeviceMiddleware
{
    public function handle($request, Closure $next)
    {
        $user = Auth::user2();
        
        if ($user) {
            $deviceId = $request->header('X-Device-ID');

            if (!$deviceId) {
                return response()->json(['error' => 'Device ID is required'], 400);
            }

            $token = $user->token();
            $existingTokens = DB::table('oauth_access_tokens')
                ->where('user_id', $user->id)
                ->where('device_id', $deviceId)
                ->pluck('id')
                ->toArray();

            if (!in_array($token->id, $existingTokens)) {
                if (count($existingTokens) >= 1) {
                    DB::table('oauth_access_tokens')
                        ->where('id', $existingTokens[0])
                        ->delete();
                }

                DB::table('oauth_access_tokens')
                    ->where('id', $token->id)
                    ->update(['device_id' => $deviceId]);
            }
        }

        return $next($request);
    }
}
