<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class EnsureUserIsPremium
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle($request, Closure $next)
{
    if (auth()->check() && auth()->user()->premuim === 1 && auth()->user()->expired_in >= now()) {
        return $next($request);
    }

    return redirect('login/premium')->with('error', 'Você precisa ser um usuário premium pra acessar essa página.');
}

}
