<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use App\UserSession;

class CheckSingleSession
{
    public function handle(Request $request, Closure $next)
    {
        // Ignorar verificação para rotas de admin
        if (strpos($request->path(), 'admin') === 0) {
            return $next($request);
        }

        $user = $request->user();
        $deviceToken = session('device_token');

        if ($user && $deviceToken) {
            $session = UserSession::where('user_id', $user->id)
                                ->where('device_token', $deviceToken)
                                ->first();

            if (!$session) {
                // Se você está usando Laravel Passport
                if (method_exists($user, 'token') && $user->token()) {
                    $user->token()->revoke();
                }

                Auth::guard('web')->logout();
                return redirect('/login')->with('error', 'Apenas 1 dispositivo por conta é permitido');
            }
        }

        return $next($request);
    }
}
