<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;

class CheckPremiumStatus
{
    /**
     * Verifica se o usuário tem status premium ativo.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        if (!Auth::check()) {
            return redirect()->route('login.premium.view')
                ->with('error', 'Você precisa fazer login para acessar esta área.');
        }

        $user = Auth::user();

        // Log para diagnóstico
        Log::info('Verificação de status premium via middleware', [
            'user_id' => $user->id,
            'premium' => $user->premuim,
            'expired_in' => $user->expired_in
        ]);

        // Usar o método auxiliar criado no modelo
        if (!$user->isPremiumActive()) {
            Auth::logout();
            return redirect()->route('login.premium.view')
                ->with('error', 'Acesso permitido apenas para membros com plano premium ativo.');
        }

        return $next($request);
    }
}
