<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\User;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Twilio\Rest\Client;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Storage;


class WebhookMercadoPagoController extends Controller
{
    public function handleMercadoPagoWebhook(Request $request)
    {
        $url = $request->fullUrl();
        $parsedUrl = parse_url($url);
        $queryParams = [];
        parse_str($parsedUrl['query'], $queryParams);

        if (isset($queryParams['id'])) {
            $collectionId = $queryParams['id'];
            $accessToken = env('MERCADOPAGO_ACCESS_TOKEN');
            $url = "https://api.mercadopago.com/v1/payments/{$collectionId}?access_token={$accessToken}";

            $response = Http::get($url);

            if ($response->successful()) {
                $payment = $response->json();


                if ($payment['status'] == 'approved') {
                    $tvAccess = $payment['metadata']['tv_access'] ?? null;
                    $expiredInTv = $payment['metadata']['expired_in_tv'] ?? null;

                    $email = $payment['metadata']['cliente'][0]['email'] ?? null;
                    $nome = $payment['metadata']['cliente'][0]['first_name'] ?? null;
                    $dias = $payment['metadata']['items'][0]['description'] ?? null;

                    if (!$email || !$nome) {
                        return response()->json(['error' => 'Informações essenciais do cliente não encontradas na metadata'], 422);
                    }

                    $usuario = DB::table('users')->where('email', '=', $email)->first();

                    if ($tvAccess == 1 && $expiredInTv && $usuario) {
                        DB::table('users')
                            ->where('email', '=', $email)
                            ->update([
                                'tv_access' => 1,
                                'expired_in_tv' => Carbon::now()->addDays($expiredInTv)
                            ]);
                    }

                    if ($usuario) {
                        // Atualiza o usuário existente com informações adicionais
                        DB::table('users')
                            ->where('email', '=', $email)
                            ->update([
                                "premuim" => true,
                                "expired_in" => Carbon::now()->addDays($dias)
                            ]);
                    } else {
                        // Cria um novo usuário com informações recebidas do pagamento
                        $randomPassword = Str::random(6);
                        $novoUsuario = [
                            'email' => $email,
                            'name' => $nome,
                            'password' => Hash::make($randomPassword),
                            'premuim' => true,
                            'expired_in' => Carbon::now()->addDays($dias),
                        ];
                        
                        DB::table('users')->insert($novoUsuario);
                    }
                    return response()->json(['success' => 'Processamento concluído'], 200);
                }
            }
        }
        return response()->json(['error' => 'Requisição inválida ou dados não processados'], 200);
    }



public function enviarMensagemWhatsAppTeste()
    {
        $sid = env("TWILIO_SID");
        $token = env("TWILIO_TOKEN");
        $twilio = new Client($sid, $token);

        $nome = "Guilherme";
        $numeroDestinatario = "+5521990230539";
        $email = "guilherme97226388@gmail.com";
        $randomPassword = "123456";
        $link = "https://site.ultraflix.net";
        $contentSid = "HXd93ab415b49d48cf8aca7888c2bff829"; // Substitua pelo SID do seu template
    
        try {
            $message = $twilio->messages->create(
                "whatsapp:{$numeroDestinatario}", // Número de destino
                [
                    "contentSid" => $contentSid,
                    "from" => "MGb4aa24691d6232df69d44351c627bd79",
                    "contentVariables" => json_encode([
                        "1" => "$nome",
                        "2" => "$link"
                        
                    ])
                ]
            );

            return "Mensagem enviada. SID: {$message->sid}";
        } catch (\Exception $e) {
            return "Erro ao enviar mensagem: " . $e->getMessage();
        }

    }

public function searchPaymentByExternalReference()
{
    $accessToken = env('MERCADOPAGO_ACCESS_TOKEN');
    $externalReference = "anapaulaquilesm@gmail.com";
    $url = "https://api.mercadopago.com/v1/payments/search?access_token={$accessToken}&criteria=desc";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
    ]);

    $response = curl_exec($ch);
    $statusCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($statusCode == 200) {
        return response()->json(json_decode($response, true));
    }

    return response()->json(['error' => 'Erro ao buscar o pagamento'], $statusCode);
}


}
