<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\User;
use Illuminate\Support\Facades\Log;
use Carbon\Carbon;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;

class WebhookController extends Controller
{
    public function handle(Request $request)
{
    $data = $request->all();
    Log::info('Webhook recebido: ', $data);

    if (isset($data['type']) && $data['type'] === 'STATUS_ALTERADO') {
        $planDurations = [
            'plaz9j0l' => 30,
            'plao161x' => 60,
            'plag1klv' => 90,
            
        ];

        if (isset($data['trans_status_code']) && $data['trans_status_code'] === 2) {
            $email = $data['client_email'];
            $productId = $data['plan_key'];
            $productName = $data['plan_name'];
            $usuarioNome =$data['client_name'];

            $user = User::where('email', $email)->first();

            if (!$user) {
                // Gerar senha aleatória
                $password = rand(100000, 999999);

                // Criar novo usuário
                $user = new User();
                $user->name = $usuarioNome;
                $user->email = $email;
                $user->password = Hash::make($password);
                $user->premuim = 1;
                $user->expired_in = Carbon::now()->addDays($planDurations[$productId]);
                $user->pack_name = $productName;
                $user->save();

                try {
                    Mail::send('emails.password', ['password' => $password], function ($message) use ($email) {
                        $message->to($email)->subject('Sua nova senha');
                    });
                } catch (\Exception $e) {
                    Log::error('Falha ao enviar email: ' . $e->getMessage());
                    // Você pode querer retornar ou manipular o erro de alguma forma aqui
                }
                
            }

            if (array_key_exists($productId, $planDurations)) {
                $user->premuim = 1; 
                $user->expired_in = Carbon::now()->addDays($planDurations[$productId]);
                $user->pack_name = $productName;
                $user->save();
                Log::info('Usuário atualizado para premium: ', ['email' => $email]);
            } else {
                Log::error('Plano não reconhecido: ', ['product_id' => $productId]);
                return response()->json(['message' => 'Plano não reconhecido.'], 404);
            }
        } else {
            Log::error('Dados do webhook inválidos ou status do pedido não é pago.');
            return response()->json(['message' => 'Dados inválidos ou status do pedido não é pago.'], 400);
        }
    } else {
        Log::error('Tipo de webhook não suportado.');
        return response()->json(['message' => 'Tipo de webhook não suportado.'], 400);
    }

    return response()->json(['message' => 'Webhook processado.'], 200);
}

public function tribopay(Request $request)
{
    $data = $request->all();
    Log::info('Webhook recebido: ', $data);

    if (isset($data['event']) && $data['event'] === 'transaction') {
        $planDurations = [
            'm68jvzcc50' => 30,
            'plao161x' => 60,
            'plag1klv' => 90,
        ];

        if (isset($data['transaction']['status']) && $data['transaction']['status'] === 'paid') {
            $email = $data['customer']['email'];
            $productId = $data['items'][0]['product_hash']; // Primeiro item da lista de items
            $productName = $data['items'][0]['title']; // Usando o título do primeiro item
            $usuarioNome = $data['customer']['name'];

            $user = User::where('email', $email)->first();

            if (!$user) {
                // Gerar senha aleatória
                $password = rand(100000, 999999);

                // Criar novo usuário
                $user = new User();
                $user->name = $usuarioNome;
                $user->email = $email;
                $user->password = Hash::make($password);
                $user->premuim = 1;
                if (array_key_exists($productId, $planDurations)) {
                    $user->expired_in = Carbon::now()->addDays($planDurations[$productId]);
                } else {
                    Log::error('Plano não reconhecido: ', ['product_id' => $productId]);
                    return response()->json(['message' => 'Plano não reconhecido.'], 404);
                }
                $user->pack_name = $productName;
                $user->save();

                try {
                    Mail::send('emails.password', ['password' => $password], function ($message) use ($email) {
                        $message->to($email)->subject('Sua nova senha');
                    });
                } catch (\Exception $e) {
                    Log::error('Falha ao enviar email: ' . $e->getMessage());
                    // Você pode querer retornar ou manipular o erro de alguma forma aqui
                }
            }

            if (array_key_exists($productId, $planDurations)) {
                $user->premuim = 1;
                $user->expired_in = Carbon::now()->addDays($planDurations[$productId]);
                $user->pack_name = $productName;
                $user->save();
                Log::info('Usuário atualizado para premium: ', ['email' => $email]);
            } else {
                Log::error('Plano não reconhecido: ', ['product_id' => $productId]);
                return response()->json(['message' => 'Plano não reconhecido.'], 404);
            }
        } else {
            Log::error('Dados do webhook inválidos ou status do pedido não é pago.');
            return response()->json(['message' => 'Dados inválidos ou status do pedido não é pago.'], 400);
        }
    } else {
        Log::error('Tipo de webhook não suportado.');
        return response()->json(['message' => 'Tipo de webhook não suportado.'], 400);
    }

    return response()->json(['message' => 'Webhook processado.'], 200);
}


public function testeMail() {
    $email = 'guilherme97226388@gmail.com';
    $password = '123456';
    try {
        Mail::send('emails.password', ['password' => $password], function ($message) use ($email) {
            $message->to($email)->subject('Sua nova senha');
        });
    } catch (\Exception $e) {
        Log::error('Falha ao enviar email: ' . $e->getMessage());
        // Você pode querer retornar ou manipular o erro de alguma forma aqui
    }
}

}
