<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\UsuarioSorteio;
use App\User;

class UsuarioSorteioController extends Controller
{
    public function create()
    {
        return view('sorteio');
    }
    

    public function store(Request $request)
{
    $messages = [
        'email.required' => 'O e-mail é obrigatório.',
        'email.email' => 'O e-mail fornecido não é válido.',
        'email.unique' => 'O e-mail informado já foi cadastrado para um sorteio.',
        'email.exists' => 'O e-mail não foi encontrado.',
        'email.premium' => 'O e-mail informado não é premium.'
    ];
    
    $request->validate([
        'email' => [
            'required',
            'email',
            'unique:usuarios_sorteio,email',  
            'exists:users,email', 
            function ($attribute, $value, $fail) {
                $user = User::where('email', $value)->first();
                if (!$user) {
                    $fail('E-mail não encontrado.');
                } elseif ($user->premuim != 1) {
                    $fail('O e-mail informado não é premium.'); // Aqui utilizamos a chave da mensagem personalizada
                }
            },
        ],
        'nome' => 'required|string|max:255',
        'chave_pix' => 'required|string|max:255',
        'whatsapp' => 'required|string|max:25', // Você pode alterar as regras de validação conforme necessário
    ], $messages);

    $usuario = new UsuarioSorteio;
    $usuario->email = $request->email;
    $usuario->nome = $request->nome;
    $usuario->chave_pix = $request->chave_pix;
    $usuario->whatsapp = $request->whatsapp; // Armazene o número do WhatsApp
    $usuario->save();

    return redirect()->back()->with([
        'success' => 'Cadastro realizado com sucesso!',
        'error'   => 'Ocorreu um erro ao processar seu pagamento.'
    ]);
}


    public function winners()
    {
        $winners = UsuarioSorteio::where('sorteado', 1)->get();
        return view('winners', compact('winners'));
    }
}