<?php

namespace App\Http\Controllers;

use Illuminate\Validation\Rule;
use App\Http\Requests\AvatarRequest;
use App\Http\Requests\PasswordUpdateRequest;
use App\Http\Requests\PasswordAppRequest;
use App\Http\Requests\DeviceStoreRequest;
use App\Http\Requests\UserRequest;
use Illuminate\Http\Request;
use App\Http\Requests\UserRequestStore;
use App\Http\Requests\UserUpdateRequest;
use App\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\DB;
use Laravel\Passport\Client;
use App\Setting;
use App\Profile;
use App\Device;
use Illuminate\Support\Carbon;
use Sentinel;
use App\Exports\UsersEmailExport;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Facades\File;
use App\Services\BackblazeService;

class UserController extends Controller
{
    protected $backblaze;

    public function __construct(BackblazeService $backblaze)
        {
            $this->middleware('doNotCacheResponse', ['only' => ['checkExpirationDate']]);
            $this->backblaze = $backblaze;
        }


    const MESSAGE = "successfully updated";



    public function showUser($id)
    {

        $user = User::query()
        ->where('id', '=', $id)->select(['id','name'])->get();

        return response()->json($user);

    }


    public function devices (Request $request){


        $auth = Auth()->user();

        $user = Device::query()->where('user_id', '=', $auth->id)->get();


         return response()->json(['devices' => $user], 200);
     }

    public function createDevice (Request $request){


            $user = Auth()->user();


            $dev = Device::where('serial_number', $request->serial_number)->
            where('user_id', $user->id)->first();


            if (!$dev) {

            $this->validate($request, [
            'serial_number' => [
            'required',
            ],
            ]);



        $device = new Device();
        $device->name = $request->name;
        $device->model = $request->model;
        $device->serial_number = $request->serial_number;
        $device->user_id = $user->id;
        $user->devices()->save($device);


            }



        if ($device != null) {

            $data = ['status' => 200, 'message' => 'Device successfully Attached',];
        } else {
            $data = ['status' => 400, 'message' => 'Device Already Attached',];
        }

            return response()->json($data, 200);

     }




     public function deleteDevice ($id,Request $request){


        $user = Auth()->user();

        $deleteProfile = Device::find($id)->delete();


        if ($deleteProfile != null) {

            $data = ['status' => 200, 'message' => 'successfully removed',];
        } else {
            $data = ['status' => 400, 'message' => 'could not be deleted',];
        }

         return response()->json($data, 200);
     }


     public function createProfile(Request $request)
     {
         $this->validate($request, [
             'name' => 'required'
         ]);

         $user = Auth()->user();

         // Verificar o número de perfis que o usuário já tem
         if ($user->profiles()->count() >= 3) {
             $data = [
                 'status' => 400,
                 'message' => 'Limite de perfis atingido. Você só pode criar até 2 perfis.',
                 'type' => 'error'  // Adicionando tipo para estilização
             ];
             return redirect()->route('choose-profile')->with('response', $data);
         }

         $profile = new Profile();
         $profile->name = $request->name;

         if ($request->avatar == null) {
             // Avatar padrão - salvar apenas o caminho relativo
             $profile->avatar = '/avatars/avatar_default.png';
         } else {
             // Extrair apenas o caminho relativo da URL do avatar
             $avatarPath = parse_url($request->avatar, PHP_URL_PATH);
             $profile->avatar = $avatarPath;
         }

         $user->profiles()->save($profile);

         if ($profile != null) {
             $data = [
                 'status' => 200,
                 'message' => 'Perfil Criado com Sucesso',
                 'type' => 'success'  // Adicionando tipo para estilização
             ];
         } else {
             $data = [
                 'status' => 400,
                 'message' => 'Não foi possível criar o perfil',
                 'type' => 'error'  // Adicionando tipo para estilização
             ];
         }

         return redirect()->route('choose-profile')->with('response', $data);
     }




     public function showDefaultAvatar($filename){

       $image = Storage::disk('avatars')->get($filename);

       $mime = Storage::disk('avatars')->mimeType($filename);

       return (new Response($image, 200))->header('Content-Type', $mime);
    }

     public function deleteProfile (Request $request){


        $user = Auth()->user();


        $deleteProfile = Profile::find($request->profile_id)->delete();


        if ($deleteProfile != null) {

            $data = ['status' => 200, 'message' => 'Perfil Deletado com Sucesso',];
        } else {
            $data = ['status' => 400, 'message' => 'Ocorreu um Erro ao Deletar o Perfil',];
        }

        return redirect()->route('choose-profile')->with('response', $data);
     }



    public function QrAutoGenerate(Request $request)
	{
		$result=0;
		if ($request->action = 'updateqr') {
			$user = Sentinel::getUser();
			if ($user) {
				$qrLogin=bcrypt($user->personal_number.$user->email.str_random(40));
		        $user->QRpassword= $qrLogin;
		        $user->update();
		        $result=1;
			}

		}

        return $result;
	}


    public function checkExpirationDate (Request $request){

        $user = Auth()->user();

        $s =  date('Y-m-d', strtotime($user->expired_in));

        if(Carbon::now()->startOfDay()->gte($s)){


         $data = ['status' => 200, 'subscription' => "expired"];

        }else{

           $data = ['status' => 200, 'subscription' => "notexpired"];
        }

        return response()->json($data, 200);
     }




    public function create(Request $request)
    {

        $this->validate($request, [
            'name' => 'required',
            'email' => 'required|email|unique:users,email',
            'password' => 'required|min:6'
        ]);

        $user = User::create([
            'name' => request('name'),
            'email' => request('email'),
            'premuim' => false,
            'password' => bcrypt(request('password'))


        ]);

        return $this->issueToken($request, 'password');

    }





    // returns the authenticated user for admin panel

    public function data()
    {


        $user = Auth()->user();
        return response()
        ->json( $user, 200);


    }




    public function allusers()
    {

        return response()->json(User::orderByDesc('created_at')
        ->paginate(12), 200);
    }


    // return the logo checking the format
    public function showAvatar()

    {
        if (Storage::disk('public')->exists('users/users.jpg')) {
            $image = Storage::disk('public')->get('users/users.jpg');
            $mime = Storage::disk('public')->mimeType('/users/users.jpg');
            $type = 'jpg';
        } else {
            $image = Storage::disk('public')->get('users/users.png');
            $mime = Storage::disk('public')->mimeType('users/users.png');
            $type = 'png';
        }
        return (new Response($image, 200))
            ->header('Content-Type', $mime)->header('type', $type);
    }


    public function updateAvatar(AvatarRequest $request)
    {
        if ($request->hasFile('image')) {
            Storage::disk('public')->deleteDirectory('users');
            $extension = $request->image->getClientOriginalExtension();
            $filename = Storage::disk('public')->putFileAs('users', $request->image, "users.$extension");
            $data = [
                'status' => 200,
                'image_path' => $request->root() . '/api/image/users?' . time(),
            ];
        } else {
            $data = [
                'status' => 400,
            ];
        }

        return response()->json($data, $data['status']);
    }



      // update user data in the database
      public function phoneUpdate(Request $request)
      {
        $this->validate($request, [
            'id' => 'required']);


        $user = Auth::user();


        DB::table('users')
            ->where('id',$request->id)
            ->update(
                array(
                    "verified" => 1));

      return response()->noContent();

      }


    // update user data in the database
    public function update(UserRequest $request)
    {
        $user = Auth()->user();

        if ($request->get('password') == '') {
            $user->update($request->except('password'));
        } else {
            $user->update($request->all());
        }
        $user->save();


        $data = [
            'status' => 200,
            self::MESSAGE,
            'body' => $user
        ];

        return response()->json($data, $data['status']);
    }


    public function isSubscribed(Request $request)
    {

     $user = Auth()->user();



      return response()->json($data = [
        'active' => $user->subscriptions()->active()->count()]);



    }



    public function store(Request $request){


        $this->validate($request, [
            'name' => 'required',
            'email' => 'required|email|unique:users,email',
            'password' => 'required|min:6'
        ]);

        $user = User::create([
            'name' => request('name'),
            'email' => request('email'),
            'premuim' => false,
            'password' => bcrypt(request('password'))


        ]);

    }


    public function addUser(Request $request)
    {

        //validation for inputs
        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'email' => 'required|email'
        ]);
        $return['message'] = 'Please enter valid inputs';
        if ($validator->fails()) {
            return $return;
        }

        //Add user
        $user = new User();
        $user->name = $request->name;
        $user->email = $request->email;
        $user->role = $request->role;
        $user->password = Hash::make(rand(10000, 99999));
        $user->save();
        return $user;
    }


    public function updateUser(UserUpdateRequest $request, User $user)


    {

        if ($user != null) {

            $user->fill($request->user);
            $user->save();

            $data = [
                'status' => 200,
                self::MESSAGE,
            ];
        } else {
            $data = [
                'status' => 400,
                'message' => 'Error',
            ];
        }

        return response()->json($data, $data['status']);
    }


    public function destroy(User $user)
{
    if ($user != null) {
        // Excluir registros favoritos relacionados a cada perfil do usuário
        foreach ($user->profiles as $profile) {
            $profile->favoriteMovies()->detach();
            $profile->favoriteSeries()->detach();
            $profile->favoriteAnimes()->detach();
            $profile->delete(); // Exclui o perfil após remover os favoritos relacionados
        }

        // Após excluir todos os perfis e seus favoritos relacionados, exclua o usuário
        $user->delete();

        return response()->json([
            'status' => 200,
            'message' => 'User and related profiles successfully removed',
        ]);
    } else {
        return response()->json([
            'status' => 400,
            'message' => 'User could not be deleted',
        ]);
    }
}



    // update user password in the database
    public function passwordUpdate(PasswordUpdateRequest $request)
    {
        $user = Auth()->user();
        $user->password = bcrypt($request->password);
        $user->save();
        $data = [
            'status' => 200,
            self::MESSAGE,
        ];

        return response()->json($data, $data['status']);
    }




    public function passwordUpdateApp(PasswordAppRequest $request)
    {

        $settings = Setting::first();
        $settings->password = bcrypt($request->password);
        $settings->save();
        $data = [
            'status' => 200,
            self::MESSAGE,
        ];

        return response()->json($data, $data['status']);
    }


 // update user password in the database
 public function updateUserPassword (PasswordUpdateRequest $request)
 {
     $user = Auth()->user();
     $user->password = bcrypt($request->password);
     $user->save();
     $data = [
         'status' => 200,
         self::MESSAGE,
     ];

     return response()->json($data, $data['status']);
 }




 public function show($filename)
 {

    $image = Storage::disk('avatars')->get($filename);

    $mime = Storage::disk('avatars')->mimeType($filename);

    return (new Response($image, 200))->header('Content-Type', $mime);
 }

 public function exportLatestEmails()
{
    $emailsToExport = 100;

    // Seleciona os últimos 2 mil e-mails válidos com domínios específicos
    $latestEmails = User::orderBy('id', 'desc')
                        ->pluck('email')
                        ->filter(function ($email) {
                            // Valida o e-mail usando uma expressão regular para domínios específicos
                            return filter_var($email, FILTER_VALIDATE_EMAIL) !== false &&
                                   preg_match('/@(gmail\.com|hotmail\.com|outlook\.com)$/i', $email);
                        })
                        ->take($emailsToExport);

    // Converte a coleção de e-mails em uma string separada por vírgulas
    $emailsString = $latestEmails->implode(',');

    // Define o nome do arquivo
    $fileName = 'latest_valid100_emails.csv';

    // Cria e escreve a string de e-mails em um arquivo CSV
    file_put_contents(storage_path('app/public/' . $fileName), $emailsString);

    // Gera o link para download
    $filePath = storage_path('app/public/' . $fileName);

    // Retorna o arquivo para download
    return response()->download($filePath)->deleteFileAfterSend(true);
}

public function usersWithWhatsapp()
{
    $currentDate = Carbon::now(); // Data atual

    $users = User::select('id', 'name', 'whatsapp')
                 ->whereNotNull('whatsapp')
                 ->where('whatsapp', '!=', '')
                 ->where('expired_in', '<', $currentDate) // Filtra usuários com expired_in anterior à data atual
                 ->paginate(100); // Paginação para evitar timeouts

    // Transformar os usuários para retornar apenas os campos necessários
    $transformedUsers = $users->map(function ($user) {
        return [
            'id' => $user->id,
            'name' => $user->name,
            'whatsapp' => $user->whatsapp,
        ];
    });

    // Montar a resposta incluindo a contagem total de usuários
    return response()->json([
        'total' => $users->total(), // Total de usuários com WhatsApp preenchido e expired_in anterior à data atual
        'data' => $transformedUsers, // Dados dos usuários
        'current_page' => $users->currentPage(), // Página atual
        'last_page' => $users->lastPage(), // Última página
        'per_page' => $users->perPage(), // Usuários por página
    ]);
}



public function exportUsersWithWhatsapp()
{
    $currentDate = Carbon::now(); // Data atual

    // Filtrar os usuários
    $users = User::select('name', 'whatsapp as phone')
                 ->whereNotNull('whatsapp')
                 ->where('whatsapp', '!=', '')
                 ->where('expired_in', '<', $currentDate)
                 ->get();

    // Nome do arquivo CSV
    $fileName = 'users_with_whatsapp_' . $currentDate->format('Ymd_His') . '.csv';

    // Criar o conteúdo do CSV
    $headers = ['Name', 'Phone'];
    $csvContent = implode(',', $headers) . "\n"; // Adiciona os cabeçalhos

    foreach ($users as $user) {
        $csvContent .= implode(',', [$user->name, $user->phone]) . "\n"; // Adiciona cada usuário
    }

    // Retornar a resposta CSV para download
    return response($csvContent)
        ->header('Content-Type', 'text/csv')
        ->header('Content-Disposition', "attachment; filename=\"$fileName\"");
}





public function showProfiles()
{
    $user = Auth()->user();
    $profiles = $user->profiles;
    $deviceToken = session('device_token');
    return view('auth.choose-profile', compact('profiles'));
}

public function showCreateProfileForm()
{
    $avatars = $this->getAvatarList();
    return view('auth.create-profile', compact('avatars'));
}


public function getAvatarList()
{
    // Define o caminho para a pasta de avatares
    $avatarPath = public_path('avatars');

    // Verifica se o diretório existe
    if (!is_dir($avatarPath)) {
        return []; // Retorna um array vazio se o diretório não existir
    }

    $avatars = [];

    // Escaneia o diretório em busca de arquivos
    $files = scandir($avatarPath);

    // Itera sobre os arquivos encontrados
    foreach ($files as $file) {
        // Ignora os diretórios especiais . e ..
        if ($file === '.' || $file === '..') {
            continue;
        }

        // Caminho completo do arquivo
        $filePath = $avatarPath . '/' . $file;

        // Verifica se é um arquivo e se é um PNG
        if (is_file($filePath) && pathinfo($file, PATHINFO_EXTENSION) === 'png') {
            // Salvando apenas o caminho relativo
            $avatars[] = '/avatars/' . $file;
        }
    }

    // Embaralha os avatares para dar uma ordem aleatória
    shuffle($avatars);

    return $avatars; // Retorna a lista de caminhos relativos dos avatares
}

public function selectProfile($profile_id)
{
    $profile = Profile::find($profile_id);
    session(['selected_profile' => $profile]);
    return redirect()->route('inicio');
}

public function editProfile($profile_id, BackblazeService $backblaze)
{
    try {
        $profile = Profile::findOrFail($profile_id);
        $avatars = $this->getAvatarList();

        $data = [
            'status' => 200,
            'message' => 'Perfil carregado com sucesso',
            'type' => 'success'
        ];

        return view('auth.edit-profile', compact('profile', 'avatars'))->with('response', $data);

    } catch (\Exception $e) {
        $data = [
            'status' => 400,
            'message' => 'Erro ao carregar o perfil: ' . $e->getMessage(),
            'type' => 'error'
        ];
        return redirect()->route('choose-profile')->with('response', $data);
    }
}

public function updateProfile(Request $request, $profile_id)
{
    $profile = Profile::find($profile_id);
    $profile->name = $request->name;

    if ($request->hasFile('avatar')) {
        // Se enviou um arquivo novo, salva-o e armazena o caminho relativo
        $avatarPath = $request->file('avatar')->store('avatars', 'public');
        $profile->avatar = '/' . $avatarPath; // Armazena o caminho relativo
    } elseif ($request->input('avatar')) {
        // Se selecionou um avatar existente, extrair apenas o caminho relativo
        $avatarPath = parse_url($request->input('avatar'), PHP_URL_PATH);
        $profile->avatar = $avatarPath;
    }

    $profile->save();

    return redirect()->route('choose-profile')->with([
        'status' => 'Perfil atualizado com sucesso!',
        'response' => [
            'status' => 200,
            'message' => 'Perfil atualizado com sucesso!',
            'type' => 'success'
        ]
    ]);
}


}
