<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use BackblazeB2\Client;
use BackblazeB2\Bucket;

class TMDBExportController extends Controller
{
    public function export()
    {
        // Buscar tmdb_id da tabela movies
        $tmdbIds = DB::table('movies')->pluck('tmdb_id')->toArray();

        // Converter array para string separada por vírgulas
        $tmdbIdsString = implode(',', $tmdbIds);

        // Salvar em um arquivo txt temporário
        $tempFile = tempnam(sys_get_temp_dir(), 'tmdb_ids');
        file_put_contents($tempFile, $tmdbIdsString);

        // Inicializar cliente Backblaze
        $client = new Client('17533f925c8f', '00538a6e86eaba8906ec17fb923047c39cc479fdbf', [
            'bucketName' => 'utxgmpx'
        ]);

        // Fazer upload do arquivo txt para Backblaze
        $client->upload([
            'BucketName' => 'utxgmpx',
            'FileName' => 'tmdb_ids.txt',
            'Body' => fopen($tempFile, 'r')
        ]);

        // Deletar o arquivo temporário
        unlink($tempFile);

        return response()->json(['message' => 'IDs TMDB exportados e enviados com sucesso.']);
    }
}
