<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;
use Symfony\Component\HttpFoundation\StreamedResponse;

class SqlDownloadController extends Controller
{
    /**
     * Exibe o formulário de download
     *
     * @return \Illuminate\View\View
     */
    public function showForm()
    {
        return view('download_sql');
    }

    /**
     * Processa o download do SQL após validação
     *
     * @param Request $request
     * @return \Symfony\Component\HttpFoundation\StreamedResponse
     */
    public function downloadSql(Request $request)
    {
        // Se chegamos aqui, o middleware já validou a senha e os limites

        // Registra o início do download
        Log::info("Iniciando geração de arquivo SQL para download");

        // Define o nome do arquivo
        $filename = 'ultraflix_database_' . date('Y-m-d') . '.sql';

        // Cria uma resposta streaming para não sobrecarregar a memória
        $response = new StreamedResponse(function () {
            // Obtém conexão e informações do banco
            $database = config('database.connections.mysql.database');

            // Abre o output para streaming
            $output = fopen('php://output', 'w');

            // Cabeçalho do arquivo SQL
            fwrite($output, "-- UltraFlix Database Backup\n");
            fwrite($output, "-- Gerado em: " . date('Y-m-d H:i:s') . "\n\n");

            // Para cada tabela no banco, faça o dump
            $tables = DB::select('SHOW TABLES');

            foreach ($tables as $table) {
                $tableName = array_values((array) $table)[0];

                // Verifica se deve pular tabelas de log, cache, etc.
                if (in_array($tableName, ['jobs', 'failed_jobs', 'migrations', 'password_resets'])) {
                    continue;
                }

                // Estrutura da tabela
                fwrite($output, "\n-- Estrutura da tabela `{$tableName}`\n\n");

                // Remove a tabela se existir
                fwrite($output, "DROP TABLE IF EXISTS `{$tableName}`;\n");

                // Obtém a estrutura CREATE TABLE
                $createTable = DB::select("SHOW CREATE TABLE `{$tableName}`");
                $createTableSql = array_values((array) $createTable[0])[1];
                fwrite($output, $createTableSql . ";\n\n");

                // Dados da tabela
                $rows = DB::table($tableName)->get();

                if (count($rows) > 0) {
                    fwrite($output, "-- Dados da tabela `{$tableName}`\n");

                    foreach ($rows->chunk(100) as $chunk) {
                        $insertSql = "INSERT INTO `{$tableName}` VALUES ";
                        $valueSets = [];

                        foreach ($chunk as $row) {
                            $values = [];
                            foreach ((array) $row as $value) {
                                if (is_null($value)) {
                                    $values[] = 'NULL';
                                } else {
                                    $values[] = "'" . str_replace("'", "''", $value) . "'";
                                }
                            }
                            $valueSets[] = '(' . implode(',', $values) . ')';
                        }

                        fwrite($output, $insertSql . implode(',', $valueSets) . ";\n");
                    }

                    fwrite($output, "\n");
                }
            }

            // Fecha o output
            fclose($output);
        });

        // Configura os headers do response
        $response->headers->set('Content-Type', 'application/sql');
        $response->headers->set('Content-Disposition', 'attachment; filename="' . $filename . '"');

        // Registra finalização do download
        Log::info("Download de SQL concluído com sucesso");

        return $response;
    }
}
