<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\SerieVideo;
use App\Episode;
use BackblazeB2\Client;
use BackblazeB2\Bucket;

class SerieVideoController extends Controller
{
    public function store(Request $request)
    {
        SerieVideo::query()->update(['link' => null]);
        
        $accountId = '17533f925c8f';
        $applicationKey = '00538a6e86eaba8906ec17fb923047c39cc479fdbf';
        $bucketId = '7107f533f3af690285ac081f';
        $buckerName = 'utxgmpx';

        // Criar um cliente Backblaze B2
        $client = new Client($accountId, $applicationKey);

        $fileList = $client->listFiles([
            'BucketId' => $bucketId
        ]);

        foreach ($fileList as $file) {
            $fileName = $file->getName();
            
            // Extrair o tmdb_id do nome do arquivo. 
            // Supõe que o nome do arquivo tem a forma "Breaking Bad S01E01 ID62085.mp4"
            preg_match('/ID(\d+)\.mp4$/', $fileName, $matches);
            $tmdb_id_in_file = $matches[1] ?? null;

            // Se encontrarmos um tmdb_id válido no nome do arquivo
            if ($tmdb_id_in_file) {
                // Obter o episódio usando o tmdb_id
                $episode = Episode::where('tmdb_id', $tmdb_id_in_file)->first();

                if ($episode) {
                    // Construir a URL do arquivo
                    $bucket_url = 'https://v.baixarfree.com/file/' . $buckerName . '/' . $fileName;

                    SerieVideo::where('episode_id', $episode->id)->delete();

                    // Salvar na tabela serie_videos
                    SerieVideo::create([
                        'episode_id' => $episode->id,
                        'link' => $bucket_url,
                        'server' => 'Servidor 1'
                    ]);
                }
            }
        }

        return response()->json($episode);

    }
}

