<?php

namespace App\Http\Controllers;

use App\Services\sCloud\SCloudService;

class SCloudController extends Controller
{
    protected $sCloudService;

    public function __construct(SCloudService $sCloudService)
    {
        $this->sCloudService = $sCloudService;
    }

    public function authUrl()
    {
        return response()->json(['auth_url' => $this->sCloudService->getAuthUrl()]);
    }

    public function accountInfo()
    {
        return response()->json($this->sCloudService->getAccountInfo());
    }
}
