<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Response;

class ProfileController extends Controller
{
    public function showProfile() {
        $user = Auth::user();
        return view('auth/profile', ['user' => $user]);
    }

    public function showDefaultAvatar($filename){
        $image = Storage::disk('public')->get($filename);
        $mime = Storage::disk('public')->mimeType($filename);
        return (new Response($image, 200))->header('Content-Type', $mime);
    }

    public function updateProfile(Request $request) {
        $data = $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|string|email|max:255|unique:users,email,' . auth()->id(),
            'password' => 'nullable|confirmed|min:6',
            'avatar' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
        ]);

        $user = auth()->user();

        $user->name = $data['name'];
        $user->email = $data['email'];

        if (!empty($data['password'])) {
            $user->password = Hash::make($data['password']);
        }

        if ($request->hasFile('avatar')) {
            // Salvar o avatar e armazenar apenas o caminho relativo
            $avatarPath = $request->file('avatar')->store('avatars', 'public');
            $user->avatar = '/' . $avatarPath; // Armazenar o caminho relativo
        }

        $user->save();

        return redirect()->back()->with('status', 'Perfil atualizado com sucesso.');
    }
}
